/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich;

import jp.terasoluna.utlib.MockFilterConfig;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.utlib.spring.SpringTestCase;

import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/**
 * {@link jp.terasoluna.fw.web.rich.RequestContextHandlingFilter} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ̐EjsT[ubgtB^B<br>
 * OFFilterConfigAFilterChainAT[ubgNGXgAT[ubgX|XNulllɂȂȂBT[ubgNGXg͕KHTTPNGXgɃLXgłB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.rich.RequestContextHandlingFilter
 */
public class RequestContextHandlingFilterTest extends SpringTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(RequestContextHandlingFilterTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.SpringTestCase#doOnSetUp()
     */
    @Override
    protected void doOnSetUp() throws Exception {
        
    }

    /**
     * Bean`t@C̏ꏊ擾B
     * 
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.SpringTestCase#getConfigLocations()
     */
    @Override
    protected String[] getConfigLocations() {
        return new String[]{
            "jp/terasoluna/fw/web/rich/RequestContextHandlingFilterTest.xml"
        };
    }

    /**
     * testInit01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() config:FilterConfigNX<br>
     *                ogetInitParamter("ctxSupportBeanID"jFnullp<br>
     *         () this.ctxSupprt:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.ctxSupprt:context.getBean("ctxSupport")̖߂lƓƂmFB<br>
     *         
     * <br>
     * RequestContextSupportNXBeanIDw肹AftHgBeanIDgpp^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit01() throws Exception {
        // FilterConfig̐ݒ
        MockFilterConfig config = new MockFilterConfig();
        config.setServletContext(servletContext);

        // RequestContextHandlingFilter̐
        RequestContextHandlingFilter filter = new RequestContextHandlingFilter();

        // eXg{
        filter.init(config);

        // 
        ApplicationContext context = WebApplicationContextUtils
                .getWebApplicationContext(config.getServletContext());
        assertSame(context.getBean("ctxSupport"), UTUtil.getPrivateField(
                filter, "ctxSupport"));
    }

    /**
     * testInit02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:FilterConfigNX<br>
     *                ogetInitParamter("ctxSupportBeanID"jF"sampleCtxSupport"p<br>
     *         () this.ctxSupprt:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.ctxSupprt:context.getBean("sampleCtxSupport")̖߂lƓƂmFB<br>
     *         
     * <br>
     * RequestContextSupportNXBeanID𒼐ڎw肷eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit02() throws Exception {
        // FilterConfig̐ݒ
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParameter("ctxSupportBeanID", "sampleCtxSupport");
        config.setServletContext(servletContext);

        // RequestContextHandlingFilter̐
        RequestContextHandlingFilter filter = new RequestContextHandlingFilter();

        // eXg{
        filter.init(config);

        // 
        ApplicationContext context = WebApplicationContextUtils
                .getWebApplicationContext(config.getServletContext());
        assertSame(context.getBean("sampleCtxSupport"), UTUtil.getPrivateField(
                filter, "ctxSupport"));
    }

    /**
     * testDoFilter01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() request:not null<br>
     *         () response:not null<br>
     *         () chain:not null<br>
     *         
     * <br>
     * ҒlF(ԕω) ctxSupport.generateContext():\bhĂяoꂽƂmFB󂯎ƂmFB<br>
     *         (ԕω) chain.doFilter():\bhĂяoꂽƂmFB󂯎ƂmFB<br>
     *         (ԕω) ctxSupprt.destroyContext():\bhĂяoꂽƂmFB<br>
     *         
     * <br>
     * tB^̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter01() throws Exception {
        // RequestContextHandlingFilter̐
        RequestContextHandlingFilter filter = new RequestContextHandlingFilter();
        RequestContextHandlingFilter_RequestContextSupportStub01 support = new RequestContextHandlingFilter_RequestContextSupportStub01();
        UTUtil.setPrivateField(filter, "ctxSupport", support);

        // ̐
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        RequestContextHandlingFilter_FilterChainStub01 chain
            = new RequestContextHandlingFilter_FilterChainStub01();

        // eXgs
        filter.doFilter(req, res, chain);

        //         
        assertTrue(chain.isDoFilterCalled());
        assertTrue(support.isGenerateContextCalled());
        assertTrue(support.isDestroyContextCalled());
    }
}
