/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.oxm.xsd.xerces;


import org.apache.xerces.impl.Constants;
import org.apache.xerces.impl.xs.XSMessageFormatter;
import org.apache.xerces.parsers.XML11Configuration;
import org.apache.xerces.xni.grammars.XMLGrammarPool;

/**
 * XMLSchemaValidatorExCX^Xp[Tɐݒ肷邽߂ɁAXML11ConfigurationgNXB
 * <p>
 * XMLSchemaValidatorEx̏ڍׂ́A{@link jp.terasoluna.fw.oxm.xsd.xerces.XMLSchemaValidatorEx}QƂ邱ƁB
 * </p>
 * 
 * @see jp.terasoluna.fw.oxm.xsd.xerces.XMLSchemaValidatorEx
 * @see jp.terasoluna.fw.oxm.xsd.xerces.SchemaValidatorImpl
 * 
 */
public class XML11ConfigurationEx extends XML11Configuration {

    /**
     * RXgN^B
     */
    public XML11ConfigurationEx() {
        super();
    }

    /**
     * RXgN^B
     * 
     * @param grammarPool OԂ̕@v[
     */
    public XML11ConfigurationEx(XMLGrammarPool grammarPool) {
        super(null, grammarPool);
    }

    /**
     * XMLSchemaValidatorExCX^Xp[TɃZbgB
     * <p>
     * X[p[NXconfigurePipeline\bhI[o[ChāAXMLSchemaValidatorExCX^Xݒ肷B
     * </p>
     */
    @Override
    protected void configurePipeline() {

        // X[p[NXconfigurePipeline\bhĂяoOɁAXMLSchemaValidatorExCX^Xp[Tɐݒ肷B
        // X[p[NXconfigurePipeline\bhXMLSchemaValidatorݒ肷R[ĥ܂܎gpB
        if (fFeatures.get(XMLSCHEMA_VALIDATION) == Boolean.TRUE) {
            // XMLSchemaValidatorEx𐶐
            fSchemaValidator = new XMLSchemaValidatorEx(
                    (XMLErrorReporterEx) getProperty(
                            Constants.XERCES_PROPERTY_PREFIX
                            + Constants.ERROR_REPORTER_PROPERTY));
            setProperty(SCHEMA_VALIDATOR, fSchemaValidator);
            addCommonComponent(fSchemaValidator);
            fSchemaValidator.reset(this);
            if (fErrorReporter.getMessageFormatter(
                    XSMessageFormatter.SCHEMA_DOMAIN) == null) {
                XSMessageFormatter xmft = new XSMessageFormatter();
                fErrorReporter.putMessageFormatter(
                        XSMessageFormatter.SCHEMA_DOMAIN, xmft);
            }
        }

        // XMLSchemaValidatorExCX^Xݒ肵ŁAX[p[NX̃\bhĂяoB
        super.configurePipeline();

    }

}
