/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.action;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.util.ExceptionUtil;
import jp.terasoluna.fw.web.RequestUtil;
import jp.terasoluna.fw.web.struts.action.DefaultExceptionHandler;
import jp.terasoluna.fw.web.struts.action.ExceptionConfigEx;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.util.MessageResources;

public class SystemExceptionHandler
extends DefaultExceptionHandler {
    private static Log log = LogFactory.getLog(SystemExceptionHandler.class);

    public ActionForward execute(Exception ex, ExceptionConfig eConfig, ActionMapping mapping, ActionForm formInstance, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String path = null;
        path = eConfig.getPath() != null ? eConfig.getPath() : mapping.getInput();
        ActionForward forward = new ActionForward(path);
        String logLevel = null;
        if (eConfig instanceof ExceptionConfigEx) {
            forward.setModule(((ExceptionConfigEx)eConfig).getModule());
            logLevel = ((ExceptionConfigEx)eConfig).getLogLevel();
        }
        if (ex instanceof SystemException) {
            Object[] options;
            SystemException se = (SystemException)ex;
            MessageResources resources = null;
            String bundle = eConfig.getBundle();
            if (bundle == null) {
                bundle = "org.apache.struts.action.MESSAGE";
            }
            if ((resources = (MessageResources)request.getAttribute(bundle)) == null) {
                resources = (MessageResources)RequestUtil.getServletContext(request).getAttribute(bundle);
            }
            String message = null;
            message = resources == null ? se.getErrorCode() : this.getErrorMessage(request, se, resources);
            se.setMessage(message);
            String key = eConfig.getKey();
            ActionMessage error = null;
            error = resources != null ? ((options = se.getOptions()) != null && options.length > 0 ? new ActionMessage(key, options) : new ActionMessage(key)) : new ActionMessage(key, false);
            super.storeException(request, key, error, forward, eConfig.getScope());
            String sessionHash = RequestUtil.getSessionHash(request);
            this.logException(logLevel, "sessionHash = " + sessionHash);
            this.logException(logLevel, ExceptionUtil.getStackTrace(se));
            request.setAttribute("javax.servlet.jsp.jspException", (Object)se);
        }
        return forward;
    }

    private String getErrorMessage(HttpServletRequest req, SystemException se, MessageResources resources) {
        String errorCode = se.getErrorCode();
        if (errorCode == null) {
            return null;
        }
        Object[] options = se.getOptions();
        if (options == null) {
            return resources.getMessage(req.getLocale(), errorCode);
        }
        return resources.getMessage(req.getLocale(), errorCode, options);
    }

    protected Log getLogger() {
        return log;
    }
}

