/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.thin;

import jp.terasoluna.utlib.MockFilterConfig;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.thin.ServerBlockageControlFilter} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * T[oǏԂǂ̃`FbNsB<br>
 * T[oǏԂꍇ́A{@link ServerBlockageException}X[B
 * <p>
 * 
 * @see jp.terasoluna.fw.web.thin.ServerBlockageControlFilter
 */
public class ServerBlockageControlFilterTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ServerBlockageControlFilterTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        UTUtil.setPrivateField(ServerBlockageControlFilter.class, 
                               "controller",
                               null);  
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public ServerBlockageControlFilterTest(String name) {
        super(name);
    }

    /**
     * testInit01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:not null<br>
     *         () config:not null<br>
     *         () getController():ServerBlockageControlFilter_ServerBlockageControllerStub01CX^X<br>
     *         () controller:ServerBlockageControlFilter_ServerBlockageControllerStub01CX^X<br>
     *         
     * <br>
     * ҒlF(ԕω) config:ŗ^FilterConfigƓ̃CX^X<br>
     *         (ԕω) getController():ĂяoȂ<br>
     *         (ԕω) controller:OƓ̃CX^X<br>
     *         
     * <br>
     * controllernullŖꍇAconrollŗ^configݒ肳AgetControllerĂяoȂƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit01() throws Exception {
        // O
        // ɐݒ肵ĂRtBO
        MockFilterConfig existingConfig = new MockFilterConfig();
        // ɐݒ肵ĂRg[
        ServerBlockageController existingController =
            new ServerBlockageControlFilter_ServerBlockageControllerStub01();
        
        UTUtil.setPrivateField(ServerBlockageControlFilter.class,
                                "controller",
                                existingController);
        // tB^̗p
        ServerBlockageControlFilter_ServerBlockageControlFilterStub01 filter
            = new ServerBlockageControlFilter_ServerBlockageControlFilterStub01();
        
        filter.setConfig(existingConfig);
        
        // Vݒ肳RtBO
        MockFilterConfig newConfig = new MockFilterConfig();
        // Vݒ肳Rg[
        ServerBlockageControlFilter_ServerBlockageControllerStub01 newController 
            = new ServerBlockageControlFilter_ServerBlockageControllerStub01();
        filter.newController = newController;
        
        // eXg{
        filter.init(newConfig);
        // 
        assertSame(newConfig, UTUtil.getPrivateField(filter, "config"));
        assertFalse(filter.isCalled);
        
        assertSame(existingController,
                UTUtil.getPrivateField(ServerBlockageControlFilter.class,
                        "controller"));
    }

    /**
     * testInit02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:not null<br>
     *         () config:null<br>
     *         () getController():ServerBlockageControlFilter_ServerBlockageControllerStub01CX^X<br>
     *         () controller:null<br>
     *         
     * <br>
     * ҒlF(ԕω) config:ŗ^FilterConfigƓ̃CX^X<br>
     *         (ԕω) getController():Ăяo<br>
     *         (ԕω) controller:getController()瓾CX^XƓ̃CX^X<br>
     *         
     * <br>
     * controllernull̏ꍇAŗ^configݒ肳AgetControllerĂяoAtB[hɐݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit02() throws Exception {
        // O
        // tB^̗p
        ServerBlockageControlFilter_ServerBlockageControlFilterStub01 filter
            = new ServerBlockageControlFilter_ServerBlockageControlFilterStub01();
        
        // Vݒ肳RtBO
        MockFilterConfig newConfig = new MockFilterConfig();
        // Vݒ肳Rg[
        ServerBlockageControlFilter_ServerBlockageControllerStub01 newController 
            = new ServerBlockageControlFilter_ServerBlockageControllerStub01();
        filter.newController = newController;
        
        // eXg{
        filter.init(newConfig);
        // 
        assertSame(newConfig, UTUtil.getPrivateField(filter, "config"));
        assertTrue(filter.isCalled);
        
        assertSame(newController,
                UTUtil.getPrivateField(ServerBlockageControlFilter.class,
                        "controller"));
    }

    /**
     * testGetServerBlockageController01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() controller:ServerBlockageControlFilter_ServerBlockageControllerStub01CX^X<br>
     *         
     * <br>
     * ҒlF(߂l) ServerBlockageController:OŐݒ肵CX^XƓ̃CX^X<br>
     *         
     * <br>
     * n1̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetServerBlockageController01() throws Exception {
        // O
        ServerBlockageController existingController =
            new ServerBlockageControlFilter_ServerBlockageControllerStub01();
        
        UTUtil.setPrivateField(ServerBlockageControlFilter.class,
                                "controller",
                                existingController);
        // eXg{
        ServerBlockageController actual =
            ServerBlockageControlFilter.getServerBlockageController();
        
        // 
        assertSame(existingController, actual);
    }

    /**
     * testDoFilter01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () SERVER_BLOCKAGE_THRU_KEY:"aaaaa"<br>
     *         () serverBlockageController:ServerBlockageControlFilter_ServerBlockageControllerStub01<br>
     *         
     * <br>
     * ҒlF(ԕω) SERVER_BLOCKAGE_THRU_KEY:OƓl<br>
     *         (ԕω) chain.doFilter:s<br>
     *         
     * <br>
     * request̑lłSERVER_BLOCKAGE_THRU_KEYnullłȂꍇAʋƖւ̑Jڃ`FbNs킸ɏI邱ƁB<br>
     * FilterChain#doFilter()\bhs邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter01() throws Exception {
        // O
        ServerBlockageController existingController =
            new ServerBlockageControlFilter_ServerBlockageControllerStub01();
 
        // tB^̗p
        ServerBlockageControlFilter filter = new ServerBlockageControlFilter();
        // eXgf[^̐ݒ
        UTUtil.setPrivateField(filter,
                                "controller",
                                existingController);
        
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setAttribute("SERVER_BLOCKAGE_THRU_KEY", "aaaaa");
        
        ServerBlockageControlFilter_FilterChainStub01 filterChain 
            = new ServerBlockageControlFilter_FilterChainStub01();
  
        // eXg{
        filter.doFilter(request, response, filterChain);    
        // 
        assertEquals("aaaaa", request.getAttribute("SERVER_BLOCKAGE_THRU_KEY"));
        assertTrue(filterChain.isCalled);
    }

    /**
     * testDoFilter02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () SERVER_BLOCKAGE_THRU_KEY:null<br>
     *         () serverBlockageController:ServerBlockageControlFilter_ServerBlockageControllerStub01<br>
     *         () .isBlockaded():false<br>
     *         
     * <br>
     * ҒlF(ԕω) SERVER_BLOCKAGE_THRU_KEY:"true"<br>
     *         (ԕω) chain.doFilter:s<br>
     *         
     * <br>
     * ʋƖւ̑Jڃ`FbNfalsȅꍇAȍ~̃`FbNs킸Arequest̑lSERVER_BLOCKAGE_THRU_KEYFiltertrueݒ肵ďI邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter02() throws Exception {
        // O
        ServerBlockageController existingController =
            new ServerBlockageControlFilter_ServerBlockageControllerStub01();
 
        // tB^̗p
        ServerBlockageControlFilter filter = new ServerBlockageControlFilter();
        // eXgf[^̐ݒ
        UTUtil.setPrivateField(filter,
                                "controller",
                                existingController);
        
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/test/logon.do");
        request.setContextPath("/test");
        MockHttpServletResponse response = new MockHttpServletResponse();
        
        ServerBlockageControlFilter_FilterChainStub01 filterChain 
            = new ServerBlockageControlFilter_FilterChainStub01();
  
        // eXg{
        filter.doFilter(request, response, filterChain);    
        // 
        assertEquals("true", request.getAttribute("SERVER_BLOCKAGE_THRU_KEY"));
        assertTrue(filterChain.isCalled);
    }

    /**
     * testDoFilter03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () SERVER_BLOCKAGE_THRU_KEY:null<br>
     *         () serverBlockageController:ServerBlockageControlFilter_ServerBlockageControllerStub02<br>
     *         () .isBlockaded():true<br>
     *         
     * <br>
     * ҒlF(ԕω) SERVER_BLOCKAGE_THRU_KEY:"true"<br>
     *         (ԕω) chain.doFilter:sȂ<br>
     *         (ԕω) O:ServerBlockageExceptionF<br>
     *         
     * <br>
     * ʋƖւ̑Jڃ`FbNtureŁAT[o[ǃ`FbNtruȅꍇArequest̑lSERVER_BLOCKAGE_THRU_KEYݒ肵ServerBlockageException邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter03() throws Exception {
        // O
        ServerBlockageController existingController =
            new ServerBlockageControlFilter_ServerBlockageControllerStub02();
 
        // tB^̗p
        ServerBlockageControlFilter filter = new ServerBlockageControlFilter();
        // eXgf[^̐ݒ
        UTUtil.setPrivateField(filter,
                                "controller",
                                existingController);
        
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/test/logon.do");
        request.setContextPath("/test");
        MockHttpServletResponse response = new MockHttpServletResponse();
        
        ServerBlockageControlFilter_FilterChainStub01 filterChain 
            = new ServerBlockageControlFilter_FilterChainStub01();
  
        // eXg{
        try {
            filter.doFilter(request, response, filterChain);
            fail();
        } catch (ServerBlockageException ex) {
            // 
            assertEquals("true", request.getAttribute("SERVER_BLOCKAGE_THRU_KEY"));
            assertFalse(filterChain.isCalled);            
        }

    }

    /**
     * testDoFilter04()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() req:not null<br>
     *         () res:not null<br>
     *         () chain:not null<br>
     *         () SERVER_BLOCKAGE_THRU_KEY:null<br>
     *         () serverBlockageController:null<br>
     *         
     * <br>
     * ҒlF(ԕω) chain.doFilter:sȂ<br>
     *         (ԕω) O:NullPointerExceptionF<br>
     *         
     * <br>
     * serverBlockageControllernull̏ꍇANullPointerException邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter04() throws Exception {
        // O
        // tB^̗p
        ServerBlockageControlFilter filter = new ServerBlockageControlFilter();
        
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/test/logon.do");
        request.setContextPath("/test");
        MockHttpServletResponse response = new MockHttpServletResponse();
        
        ServerBlockageControlFilter_FilterChainStub01 filterChain 
            = new ServerBlockageControlFilter_FilterChainStub01();
  
        // eXg{
        try {
            filter.doFilter(request, response, filterChain);
            fail();
        } catch (NullPointerException e) {
            // 
            // sȂ
            assertFalse(filterChain.isCalled);
        }           
    }

    /**
     * testGetControllerClass01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() SERVER_BLOCKAGE_CONTROLLER_CLASS:ServerBlockageController.class<br>
     *                static final<br>
     *         
     * <br>
     * ҒlF(߂l) Class:OŐݒ肵CX^XƓ̃CX^X<br>
     *         
     * <br>
     * n1̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetControllerClass01() throws Exception {
        // O
        ServerBlockageControlFilter filter = new ServerBlockageControlFilter();
        
        //  eXg{
        Class actual = filter.getControllerClass();
        
        //  
        assertEquals(ServerBlockageController.class, actual);
    }

    /**
     * testGetErrorCode01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() SERVER_BLOCKAGE_CONTROLLER_ERROR:"errors.server.blockage.controller"<br>
     *                static final<br>
     *         
     * <br>
     * ҒlF(߂l) String:"errors.server.blockage.controller"<br>
     *         
     * <br>
     * n1̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetErrorCode01() throws Exception {
        // O
        ServerBlockageControlFilter filter = new ServerBlockageControlFilter();
        
        //  eXg{
        String actual = filter.getErrorCode();
        
        //  
        assertEquals("errors.server.blockage.controller", actual);
    }

    /**
     * testGetDefaultControllerBeanId01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() DEFAULT_SERVER_BLOCKAGE_BEAN_ID:"serverBlocakgeController"<br>
     *                static final<br>
     *         
     * <br>
     * ҒlF(߂l) String:"serverBlocakgeController"<br>
     *         
     * <br>
     * n1̂݃eXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetDefaultControllerBeanId01() throws Exception {
        // O
        ServerBlockageControlFilter filter = new ServerBlockageControlFilter();
        
        //  eXg{
        String actual = filter.getDefaultControllerBeanId();
        
        //  
        assertEquals("serverBlockageController", actual);
    }

}
