/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.thin;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockFilterConfig;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.utlib.spring.SpringTestCase;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

/**
 * {@link jp.terasoluna.fw.web.thin.AbstractControlFilter} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * beanƂĎꂽRg[păANZXsۃNXB<br>
 * <p>
 * 
 * @see jp.terasoluna.fw.web.thin.AbstractControlFilter
 */
@SuppressWarnings("unused")
public class AbstractControlFilterTest extends SpringTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(AbstractControlFilterTest.class);
    }


    /**
     * testInit01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:p[^Fcontroller<br>
     *                p[^FtestControllerStub01<br>
     *         () this.config:null<br>
     *         
     * <br>
     * ҒlF(ԕω) config:ŗ^ꂽFilterConfigCX^XƓ̃CX^X<br>
     *         
     * <br>
     * ^ꂽconfigݒ肳邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit01() throws Exception {
        // O
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParameter("controller", "testControllerStub01");
        AbstractControlFilterImpl01 filter = new AbstractControlFilterImpl01();
        UTUtil.setPrivateField(filter, "config", null);
        
        // eXg{
        filter.init(config);

        // 
        assertSame(config,
                   UTUtil.getPrivateField(filter, "config"));
    }

    /**
     * testGetController01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() config.getInitParameter("controller"):null<br>
     *         () getErrorCode():"errors.test.controller"<br>
     *         () getBean():AbstractControlFilter_ControllerStub01CX^X
     *         () getControllerClass():AbstractCotnrollerFilter_TestControllerNX
     *         () getDefaultControllerBeanId():"testControllerStub01"<br>
     *         () Bean`t@C:<bean id="testControllerStub01"<br>
     *                        class="jp.terasoluna.fw.web.thin.AbstractControlFilter_ControllerStub01"/><br>
     *         
     * <br>
     * ҒlF(߂l) AbstractControlFilter_Controller:DIRei擾łControllerCX^XƓCX^X<br>
     *         
     * <br>
     * tB^̏p[^`ĂȂꍇA
     * ftHgbeanŎ擾ꂽRg[
     * ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetController01() throws Exception {
        // O
        AbstractControlFilterImpl01 filter = new AbstractControlFilterImpl01();
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParameter("controller", null);
        config.setServletContext(servletContext);
        UTUtil.setPrivateField(filter, "config", config);
        
        // eXg{
        Object obj = filter.getController();

        //         
        assertEquals(obj.getClass().getName(), 
                     AbstractControlFilter_ControllerStub01.class.getName());
    }

    /**
     * testGetController02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() config.getInitParameter("controller"):""<br>
     *         () getErrorCode():"errors.test.controller"<br>
     *         () getBean():AbstractControlFilter_ControllerStub01CX^X
     *         () getControllerClass():AbstractCotnrollerFilter_TestControllerNX
     *         () getDefaultControllerBeanId():"testControllerStub01"<br>
     *         () Bean`t@C:<bean id="testControllerStub01"<br>
     *                        class="jp.terasoluna.fw.web.thin.AbstractControlFilter_ControllerStub01"/><br>
     *         
     * <br>
     * ҒlF(߂l) AbstractControlFilter_Controller:DIRei擾łControllerCX^XƓCX^X<br>
     *         
     * <br>
     * tB^̏p[^󕶎̏ꍇA
     * ftHgbeanŎ擾ꂽRg[
     * ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetController02() throws Exception {
        // O
        AbstractControlFilterImpl01 filter = new AbstractControlFilterImpl01();
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParameter("controller", "");
        config.setServletContext(servletContext);
        UTUtil.setPrivateField(filter, "config", config);
        
        // eXg{
        Object obj = filter.getController();

        // 
        assertEquals(obj.getClass().getName(), 
                     AbstractControlFilter_ControllerStub01.class.getName());
    }

    /**
     * testGetController03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config.getInitParameter("controller"):"testControllerStub02"<br>
     *         () getErrorCode():"errors.test.controller"<br>
     *         () getBean():AbstractControlFilter_ControllerStub1CX^X
     *         () getControllerClass():AbstractCotnrollerFilter_TestControllerNX
     *         () getDefaultControllerBeanId():"testControllerStub01"<br>
     *         () Bean`t@C:<bean id="testControllerStub02"<br>
     *                        class="jp.terasoluna.fw.web.thin.AbstractControlFilter_ControllerStub01"/><br>
     *         
     * <br>
     * ҒlF(߂l) AbstractControlFilter_Controller:DIRei擾łControllerCX^XƓCX^X<br>
     *         
     * <br>
     * tB^ɏp[^𐳏ɗ^ꍇA
     * ^ꂽFilterConfigCX^XƁA
     * DIRei珉p[^Ŏ擾CX^X
     * ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetController03() throws Exception {
        // O
        AbstractControlFilterImpl01 filter = new AbstractControlFilterImpl01();
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParameter("controller", "testControllerStub02");
        config.setServletContext(servletContext);
        UTUtil.setPrivateField(filter, "config", config);
        
        // eXg{
        Object obj = filter.getController();

        //         
        assertEquals(obj.getClass().getName(), 
                     AbstractControlFilter_ControllerStub02.class.getName());
    }

    /**
     * testGetController04()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() config.getInitParameter("controller"):"aaaaa"<br>
     *         () getErrorCode():"errors.test.controller"<br>
     *         () getBean():-
     *         () getControllerClass():AbstractCotnrollerFilter_TestControllerNX
     *         () getDefaultControllerBeanId():"testControllerStub01"<br>
     *         () Bean`t@C:idaaaaał<bean>vf`ĂȂ<br>
     *         
     * <br>
     * ҒlF(߂l) AbstractControlFilter_Controller:-<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.test.controller"<br>
     *                    bvOFNoSuchBeanDefinitionException<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[WF"not found aaaaa. controller bean not defined in Beans definition file."<br>
     *                    OFNoSuchBeanDefinitionException<br>
     *         
     * <br>
     * Bean`t@CɎw肳ꂽid<bean>vf
     * `ĂȂꍇAG[Oo͂A
     * OX[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetController04() throws Exception {
        // O
        AbstractControlFilterImpl01 filter = new AbstractControlFilterImpl01();
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParameter("controller", "aaaaa");
        config.setServletContext(servletContext);
        UTUtil.setPrivateField(filter, "config", config);
        
        // eXg{
        try {
            Object obj = filter.getController();
            fail();
        } catch (SystemException e) {
            //    
            assertEquals("errors.test.controller", e.getErrorCode());
            assertEquals(e.getCause().getClass().getName(), 
                         NoSuchBeanDefinitionException.class.getName());
            assertTrue(LogUTUtil
                    .checkError("not found aaaaa. controller bean not defined in Beans definition file.",
                                e.getCause()));
        }                                   
    }

    /**
     * testGetController05()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() config.getInitParameter("controller"):"object"<br>
     *         () getErrorCode():"errors.test.controller"<br>
     *         () getBean():-
     *         () getControllerClass():AbstractCotnrollerFilter_TestControllerNX
     *         () getDefaultControllerBeanId():"testControllerStub01"<br>
     *         () Bean`t@C:<bean id="object"<br>
     *                        class="java.lang.Object"/><br>
     *         
     * <br>
     * ҒlF(߂l) AbstractControlFilter_Controller:-<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.test.controller"<br>
     *                    bvOFBeanNotOfRequiredTypeException<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[WF"controller not implemented " + getControllerClass().toString() + "."<br>
     *                    OFBeanNotOfRequiredTypeException<br>
     *         
     * <br>
     * Bean`t@C擾CX^XtB^
     * w肵ĂC^tF[XĂȂꍇA
     * G[Oo͂AOX[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetController05() throws Exception {
        // O
        AbstractControlFilterImpl01 filter = new AbstractControlFilterImpl01();
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParameter("controller", "object");
        config.setServletContext(servletContext);
        UTUtil.setPrivateField(filter, "config", config);
        
        // eXg{
        try {
            Object obj = filter.getController();
            fail();
        } catch (SystemException e) {
            //    
            assertEquals("errors.test.controller", e.getErrorCode());
            assertEquals(e.getCause().getClass().getName(),
                         BeanNotOfRequiredTypeException.class.getName());
            assertTrue(LogUTUtil
                    .checkError("controller not implemented " 
                                + filter.getControllerClass().toString() + ".",
                                e.getCause()));
        } 
    }

    /**
     * testGetController06()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() config.getInitParameter("controller"):"testControllerStub03"<br>
     *         () getErrorCode():"errors.test.controller"<br>
     *         () getBean():-
     *         () getControllerClass():AbstractCotnrollerFilter_TestControllerNX
     *         () getDefaultControllerBeanId():"testControllerStub01"<br>
     *         () Bean`t@C:<bean id="testControllerStub03"<br>
     *                        class="jp.terasoluna.fw.web.thin.AbstractControlFilter_ControllerStub02"<br>
     *                        abstract="true"/><br>
     *         
     * <br>
     * ҒlF(߂l) AbstractControlFilter_Controller:-<br>
     *         (ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.test.controller"<br>
     *                    bvOFBeansException<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[WF"bean generation failed."<br>
     *                    OFBeansException<br>
     *         
     * <br>
     * Bean`t@C擾悤ƂCX^X̃NX
     * łȂꍇAG[Oo͂AOX[邱Ƃ
     * mFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetController06() throws Exception {
        // O
        AbstractControlFilterImpl01 filter = new AbstractControlFilterImpl01();
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParameter("controller", "testControllerStub03");
        config.setServletContext(servletContext);
        UTUtil.setPrivateField(filter, "config", config);
        
        // eXg{
        try {
            Object obj = filter.getController();
            System.err.println(obj.getClass().toString());
            fail();
        } catch (SystemException e) {
            //    
            assertEquals("errors.test.controller", e.getErrorCode());
            assertTrue(e.getCause() instanceof BeansException);
            assertFalse(e.getCause() instanceof BeanNotOfRequiredTypeException);
            assertFalse(e.getCause() instanceof NoSuchBeanDefinitionException);
            System.out.println(e.getCause().toString());
            assertTrue(LogUTUtil.checkError("bean generation failed.",
                                            e.getCause()));
        } 
    }
    
    /**
     * sB
     */
    @Override
    protected void doOnSetUp() throws Exception {
    }

    /**
     * nsB
     */
    @Override
    protected void onTearDown() throws Exception {
        super.onTearDown();
    }

    /**
     * XMLt@C̈ʒuԂB
     */
    @Override
    protected String[] getConfigLocations() {
        return new String[] {
            "jp/terasoluna/fw/web/thin"
            + "/AbstractControlFilterTest.xml"};
    }

}
