/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.taglib;

import java.io.BufferedReader;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTag;

import jp.terasoluna.utlib.TagUTUtil;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.utlib.exception.Exception_JspWriterImpl;
import junit.framework.TestCase;

import com.mockrunner.mock.web.MockPageContext;

/**
 * {@link jp.terasoluna.fw.web.struts.taglib.JavascriptValidatorTagEx}
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Struts񋟂AJavascriptValidatorTagNXgNX̃eXgB<br>
 * <br>
 * doStartTag()ŁArenderKanaList()̃eXgP[X܂B
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.taglib.JavascriptValidatorTagEx
 */
public class JavascriptValidatorTagExTest extends TestCase {

    /**
     * eXgΏۃNX
     */
    private JavascriptValidatorTagEx tag = null;

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(JavascriptValidatorTagExTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        tag = (JavascriptValidatorTagEx) TagUTUtil.create(
                JavascriptValidatorTagEx_JavascriptValidatorTagExStub01.class);
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public JavascriptValidatorTagExTest(String name) {
        super(name);
    }

    /**
     * testDoStartTag01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() JavascriptValidatorTag#renderJavascript()̖߂l:"abc"<br>
     *                <br>
     *                JavascriptValidatorTag#renderJavascript()
     *                I[o[ChāA"abc"ԋpX^u쐬B<br>
     *                renderJavascript()́Asuper.doStartTag()
     *                ĂяoĂ邽߁Asuper.doStartTag()
     *                ĂяomFƂĎgpB<br>
     *         () htmlComment<br>
     *                JavascriptValidatorTag̃NXϐ:true<br>
     *         
     * <br>
     * ҒlF(߂l) int:EVAL_BODY_TAG<br>
     *         (ԕω) Writer<br>
     *                    renderKanaList()̌ĂяomFсA
     *                    super.doStartTag()̌ĂяomFsB:
     *                    <script type="text/javascript"
     *                     language="Javascript1.1"> <br>
     *                    <br>
     *                    <!-- Begin <br>
     *                    var hankakuKanaList = "¯
     *                    ֬ܦް";<br>
     *                    var zenkakuKanaList = "ACEGI@BDFHJ
     *                    LNPRKMOQSTVXZ\UWY[]^`c
     *                    eg_adfhijklmnqtwzorux{psvy
     *                    |}~b[";<br>
     *                    <br>
     *                    //End --> <br>
     *                    </script><br>
     *                    abc<br>
     *         
     * <br>
     * htmlComment̒l"true"ŁArenderKanaList()̕ԋpl𐳏ɏo͂A
     * super.doStartTag()𐳏ɌĂяoꍇ<br>
     * <br>
     * renderKanaList()̃eXg܂B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testDoStartTag01() throws Exception {
        // O
        tag.setHtmlComment("true");

        // eXg{
        int result = tag.doStartTag();

        // 
        assertEquals(result, BodyTag.EVAL_BODY_TAG);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("<script type=\"text/javascript\" " +
                "language=\"Javascript1.1\"> ", reader.readLine());
        assertEquals("", reader.readLine());
        assertEquals("<!-- Begin ", reader.readLine());
        assertEquals("var hankakuKanaList = \"¯" +
                "֬ܦް\";", reader.readLine());
        assertEquals("var zenkakuKanaList = \"ACEGI@BDFHJLNPR" +
                "KMOQSTVXZ\UWY[]^`ceg_adfhijkl" +
                "mnqtwzorux{psvy|}~" +
                "b[\";", reader.readLine());
        assertEquals("", reader.readLine());
        assertEquals("//End --> ", reader.readLine());
        assertEquals("</script>", reader.readLine());
        assertEquals("", reader.readLine());
        assertEquals("abc", reader.readLine());
    }

    /**
     * testDoStartTag02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() JavascriptValidatorTag#renderJavascript()̖߂l:"abc"<br>
     *                <br>
     *                JavascriptValidatorTag#renderJavascript()
     *                I[o[ChāA"abc"ԋpX^u쐬B<br>
     *                renderJavascript()́Asuper.doStartTag()
     *                ĂяoĂ邽߁Asuper.doStartTag()
     *                ĂяomFƂĎgpB<br>
     *         () htmlComment<br>
     *                JavascriptValidatorTag̃NXϐ:false<br>
     *         
     * <br>
     * ҒlF(߂l) int:EVAL_BODY_TAG<br>
     *         (ԕω) Writer<br>
     *                    renderKanaList()̌ĂяomFсA
     *                    super.doStartTag()̌ĂяomFsB:
     *                    <script type="text/javascript"
     *                     language="Javascript1.1"> <br>
     *                    var hankakuKanaList = "
     *                    ֬ܦް";<br>
     *                    var zenkakuKanaList = "ACEGI@BDFHJLN
     *                    PRKMOQSTVXZ\UWY[]^`ceg_ad
     *                    fhijklmnqtwzorux{psvy|}~
     *                    b[";<br>
     *                    <br>
     *                    </script><br>
     *                    abc<br>
     *         
     * <br>
     * htmlComment̒l"false"ŁArenderKanaList()̕ԋpl𐳏ɏo͂A
     * super.doStartTag()𐳏ɌĂяoꍇ<br>
     * <br>
     * renderKanaList()̃eXg܂B
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("deprecation")
    public void testDoStartTag02() throws Exception {
        // O
        tag.setHtmlComment("false");

        // eXg{
        int result = tag.doStartTag();

        // 
        assertEquals(result, BodyTag.EVAL_BODY_TAG);
        BufferedReader reader = TagUTUtil.getOutputReader(tag);
        assertEquals("<script type=\"text/javascript\" " +
                "language=\"Javascript1.1\"> ", reader.readLine());
        assertEquals("var hankakuKanaList = \"¯" +
                "֬ܦް\";", reader.readLine());
        assertEquals("var zenkakuKanaList = \"ACEGI@BDFHJLNPR" +
                "KMOQSTVXZ\UWY[]^`ceg_adfhijkl" +
                "mnqtwzorux{psvy|}~" +
                "b[\";", reader.readLine());
        assertEquals("", reader.readLine());
        assertEquals("</script>", reader.readLine());
        assertEquals("", reader.readLine());
        assertEquals("abc", reader.readLine());
    }

    /**
     * testDoStartTag03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() JspWriter#print():IOException<br>
     *         
     * <br>
     * ҒlF(ԕω) O:NXFJspException<br>
     *                    bZ[WF-<br>
     *                    bvOF-<br>
     *         
     * <br>
     * JspWriterIOExceptionꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoStartTag03() throws Exception {
        // O
        // MockIuWFNg̐ݒ
        MockPageContext pageContext
            = (MockPageContext) TagUTUtil.getPageContext(tag);

        // eXgpJspWriter̐
        Exception_JspWriterImpl out =
            new Exception_JspWriterImpl();
        out.setTrue();

        // Eݒ肵eXgpJspWriterPageContextɃZbg
        UTUtil.setPrivateField(pageContext, "jspWriter", out);

        // eXg{
        try{
            tag.doStartTag();
            fail();
        } catch (JspException e) {
            // bZ[WȂ߁AJspExceptionۂ𔻒
        }
    }

}
