/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.form;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.PropertyTestCase;

/**
 * {@link jp.terasoluna.fw.web.struts.form.FieldChecksEx}
 * NX̃ubN{bNXeXgB
 *
 * <p>
 * static߂̃eXgB</br>
 * validation.hankaku.kana.list</br>
 * validation.zenkaku.kana.list</br>
 * vpeB琳ɓǂݍނeXgB</br>
 * ̃NX͑i01`09jFieldChecksEx̃eXgƂ͕ʂVM
 * ŎsKvB
 *
 * @see jp.terasoluna.fw.web.struts.form.FieldChecksEx
 */
public class FieldChecksExTest10 extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FieldChecksExTest10.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
        LogUTUtil.flush();
        addProperty("validation.hankaku.kana.list", "hankaku.kana");
        addProperty("validation.zenkaku.kana.list", "zenkaku.kana");
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public FieldChecksExTest10(String name) {
        super(name);
    }

    /**
     * testGetHankakuKanaList01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() vpeBt@C:validation.hankaku.kana.list<br>
     *                =hankaku.kana<br>
     *
     * <br>
     * ҒlF(߂l) String:hankaku.kana<br>
     *
     * <br>
     * NXϐhankakuKanaList̒l擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetHankakuKanaList01() throws Exception {
        assertEquals("hankaku.kana",
                FieldChecksEx.getHankakuKanaList());
    }

    /**
     * testGetZenkakuKanaList01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() vpeBt@C:validation.zenkaku.kana.list<br>
     *                =zenkaku.kana<br>
     *
     * <br>
     * ҒlF(߂l) String:zenkaku.kana<br>
     *
     * <br>
     * NXϐzenkakuKanaList̒l擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetZenkakuKanaList01() throws Exception {
        assertEquals("zenkaku.kana",
                FieldChecksEx.getZenkakuKanaList());
    }

}
