/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.PropertyTestCase;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.Msg;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.Var;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

/**
 * {@link jp.terasoluna.fw.web.struts.form.FieldChecksEx}
 * NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Validatorǉ[NXB
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.form.FieldChecksEx
 */
public class FieldChecksExTest07 extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FieldChecksExTest07.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
        LogUTUtil.flush();
        deleteProperty("validation.hankaku.kana.list");
        deleteProperty("validation.zenkaku.kana.list");
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public FieldChecksExTest07(String name) {
        super(name);
    }

    /**
     * testValidateNumber01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxF<br>
     *                    G[<br>
     *                    bZ[WF<br>
     *                    bean is null.<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beannull̏ꍇAtrueԋpA
     * G[bZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber01() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[OmF
        assertTrue(LogUTUtil.checkError("bean is null."));
    }

    /**
     * testValidateNumber02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * bean󕶎̏ꍇAtrueԋpA
     * G[bZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber02() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateNumber03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"123.12"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength=null<br>
     *                var:scale=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * FieldintegerLength,scalew肳ĂȂꍇA
     * trueԋp邱ƂmFB
     * G[bZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber03() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "123.12";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        Var var = new Var();
        var.setName("integerLength");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("scale");
        var.setValue(null);
        field.addVar(var);

        // G[
        ActionMessages errors = new ActionMessages();

        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertTrue(result);
        // 2̃G[񂪓o^Ă邱
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateNumber04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:String:"123.12"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength=""<br>
     *                var:scale=""<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * FieldintegerLength,scaleɋ󕶎w肳ĂꍇA
     * trueԋp邱ƂmFB
     * G[bZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber04() throws Exception {

        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "123.12";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        Var var = new Var();
        var.setName("integerLength");
        var.setValue("");
        field.addVar(var);
        var = new Var();
        var.setName("scale");
        var.setValue("");
        field.addVar(var);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateNumber05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"123.12"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength="abc"<br>
     *                var:scale="def"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * FieldintegerLength,scaleɐlɕϊłȂ
     * w肳ĂꍇAtrueԋp邱ƂmFB
     * G[bZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber05() throws Exception {

        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "123.12";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        Var var = new Var();
        var.setName("integerLength");
        var.setValue("abc");
        field.addVar(var);
        var = new Var();
        var.setName("scale");
        var.setValue("def");
        field.addVar(var);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateNumber06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"123.12"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength=null<br>
     *                var:scale="1"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * scaleɐlw肳ĂAscale̐lA
     * bean̏_ȉ̌傫ƂAfalseԋp邱ƁA
     * G[bZ[Wǉ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber06() throws Exception {

        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "123.12";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // ݒ
        Var varInteger = new Var();
        varInteger.setName("integerLength");
        varInteger.setValue(null);
        field.addVar(varInteger);
        // ݒ
        Var varScale = new Var();
        varScale.setName("scale");
        varScale.setValue("1");
        field.addVar(varScale);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[ɃG[IuWFNgo^Ă邱ƁB
        assertEquals(1, errors.size());

        // bZ[WIuWFNǧ
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateNumber07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"123.12"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength=null<br>
     *                var:scale="3"<br>
     *                var:isAccordedScale="true"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * scaleɐlAisAccordedScaletruew肳ĂA
     * scale̐lbean̏_ȉ̌ƂA
     * falseԋp邱ƁAG[bZ[Wǉ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber07() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "123.12";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // ݒ
        Var varInteger = new Var();
        varInteger.setName("integerLength");
        varInteger.setValue(null);
        field.addVar(varInteger);
        // ݒ
        Var varScale = new Var();
        varScale.setName("scale");
        varScale.setValue("3");
        field.addVar(varScale);
        // vw
        Var varAccorded = new Var();
        varAccorded.setName("isAccordedScale");
        varAccorded.setValue("true");
        field.addVar(varAccorded);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[ɃG[IuWFNgo^Ă邱ƁB
        assertEquals(1, errors.size());
        // G[ɐݒ肳ꂽbZ[Wo^Ă邱ƁB
        Iterator it = errors.get();
        while (it.hasNext()) {
            ActionMessage error = (ActionMessage) it.next();
            assertEquals("message", error.getKey());
        }
    }

    /**
     * testValidateNumber08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"123.123"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength=null<br>
     *                var:scale="3"<br>
     *                var:isAccordedScale="true"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * scaleɐlAisAccordedScaletruew肳ĂAscale̐lƁA
     * bean̏_ȉ̌ƂAtrueԋp邱ƁA
     * G[bZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber08() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "123.123";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // ݒ
        Var varInteger = new Var();
        varInteger.setName("integerLength");
        varInteger.setValue(null);
        field.addVar(varInteger);
        // ݒ
        Var varScale = new Var();
        varScale.setName("scale");
        varScale.setValue("3");
        field.addVar(varScale);
        // vw
        Var varAccorded = new Var();
        varAccorded.setName("isAccordedScale");
        varAccorded.setValue("true");
        field.addVar(varAccorded);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateNumber09()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:String:"123.12"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength=null<br>
     *                var:scale="3"<br>
     *                var:isAccordedScale=""<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * scaleɐlAisAccordedScaleɋ󕶎w肳ĂA
     * scale̐lAbean̏_ȉ̌ƂA
     * trueԋp邱ƁAG[bZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber09() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "123.12";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // ݒ
        Var varInteger = new Var();
        varInteger.setName("integerLength");
        varInteger.setValue(null);
        field.addVar(varInteger);
        // ݒ
        Var varScale = new Var();
        varScale.setName("scale");
        varScale.setValue("3");
        field.addVar(varScale);
        // vw
        Var varAccorded = new Var();
        varAccorded.setName("isAccordedScale");
        varAccorded.setValue("");
        field.addVar(varAccorded);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateNumber10()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:String:"123.12"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength=null<br>
     *                var:scale="3"<br>
     *                var:isAccordedScale=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * scaleɐlAisAccordedScalenullw肳ĂAscale̐lA
     * bean̏_ȉ̌ƂAtrueԋp邱ƁA
     * G[bZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber10() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "123.12";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // ݒ
        Var varInteger = new Var();
        varInteger.setName("integerLength");
        varInteger.setValue(null);
        field.addVar(varInteger);
        // ݒ
        Var varScale = new Var();
        varScale.setName("scale");
        varScale.setValue("3");
        field.addVar(varScale);
        // vw
        Var varAccorded = new Var();
        varAccorded.setName("isAccordedScale");
        varAccorded.setValue(null);
        field.addVar(varAccorded);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateNumber11()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"123.12"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength=null<br>
     *                var:scale="3"<br>
     *                var:isAccordedScale="abc"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * scaleɐlAisAccordedScaletrueł͂Ȃ񂪎w肳ĂA
     * scale̐lAbean̏_ȉ̌ƂAtrueԋp邱ƁA
     * G[bZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber11() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "123.12";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // ݒ
        Var varInteger = new Var();
        varInteger.setName("integerLength");
        varInteger.setValue(null);
        field.addVar(varInteger);
        // ݒ
        Var varScale = new Var();
        varScale.setName("scale");
        varScale.setValue("3");
        field.addVar(varScale);
        // vw
        Var varAccorded = new Var();
        varAccorded.setName("isAccordedScale");
        varAccorded.setValue("abc");
        field.addVar(varAccorded);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateNumber12()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"abc"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength=null<br>
     *                var:scale="2"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * scaleɐlw肳ĂAbeanlɕϊłȂꍇA
     * falseԋp邱ƁBG[bZ[Wǉ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber12() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "abc";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // ݒ
        Var varInteger = new Var();
        varInteger.setName("integerLength");
        varInteger.setValue(null);
        field.addVar(varInteger);
        // ݒ
        Var varScale = new Var();
        varScale.setName("scale");
        varScale.setValue("2");
        field.addVar(varScale);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertEquals(1, errors.size());

        // G[IuWFNǧB
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateNumber13()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"abc.de"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength="1"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                ActionMessage("testMessage")<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("testMessage")<br>
     *                    ActionMessage("message")<br>
     *
     * <br>
     * beanlł͂ȂꍇAfalseԋp邱ƁB
     * G[bZ[Wǉ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber13() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "abc.de";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // ݒ
        Var varInteger = new Var();
        varInteger.setName("integerLength");
        varInteger.setValue("1");
        field.addVar(varInteger);

        // G[
        ActionMessages errors = new ActionMessages();
        ActionMessage error = new ActionMessage("testMessage");
        errors.add(Globals.ERROR_KEY, error);
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[ɃG[IuWFNgo^Ă邱ƁB
        assertEquals(2, errors.size());

        // G[IuWFNǧ
        Iterator it = errors.get();
        List<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            ActionMessage message = (ActionMessage) it.next();
            list.add(message.getKey());
        }
        assertTrue(list.contains("message"));
        assertTrue(list.contains("testMessage"));
    }

    /**
     * testValidateNumber14()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"123.12"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength="1"<br>
     *                var:scale=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * integerLengthɐlw肳ĂAintegerLength̐lA
     * bean̐̌傫ƂAfalseԋp邱ƁA
     * G[bZ[Wǉ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber14() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "123.12";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // ݒ
        Var varInteger = new Var();
        varInteger.setName("integerLength");
        varInteger.setValue("1");
        field.addVar(varInteger);
        // ݒ
        Var varScale = new Var();
        varScale.setName("scale");
        varScale.setValue(null);
        field.addVar(varScale);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertEquals(1, errors.size());

        // G[IuWFNǧ
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateNumber15()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"12.12"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength="3"<br>
     *                var:isAccordedInteger="true"<br>
     *                var:scale=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * integerLengthɐlAisAccordedIntegertruew肳ĂA
     * integerLength̐lbean̐̌ƂA
     * falseԋp邱ƁAG[bZ[Wǉ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber15() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "12.12";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // ݒ
        Var varInteger = new Var();
        varInteger.setName("integerLength");
        varInteger.setValue("3");
        field.addVar(varInteger);
        // vw
        Var varIsAccordedInteger = new Var();
        varIsAccordedInteger.setName("isAccordedInteger");
        varIsAccordedInteger.setValue("true");
        field.addVar(varIsAccordedInteger);
        // ݒ
        Var varScale = new Var();
        varScale.setName("scale");
        varScale.setValue(null);
        field.addVar(varScale);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertEquals(1, errors.size());

        // G[IuWFNǧ
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateNumber16()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"123.123"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength="3"<br>
     *                var:isAccordedInteger="true"<br>
     *                var:scale=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * integerLengthɐlAisAccordedIntegertruew肳ĂA
     * integerLength̐lƁAbean̐̌ƂA
     * trueԋp邱ƁAG[bZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber16() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "123.123";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // ݒ
        Var varInteger = new Var();
        varInteger.setName("integerLength");
        varInteger.setValue("3");
        field.addVar(varInteger);
        // vw
        Var varIsAccordedInteger = new Var();
        varIsAccordedInteger.setName("isAccordedInteger");
        varIsAccordedInteger.setValue("true");
        field.addVar(varIsAccordedInteger);
        // ݒ
        Var varScale = new Var();
        varScale.setName("scale");
        varScale.setValue(null);
        field.addVar(varScale);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateNumber17()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:String:"12.12"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength="3"<br>
     *                var:isAccordedInteger=""<br>
     *                var:scale=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * integerLengthɐlAisAccordedIntegerɋ󕶎w肳ĂA
     * integerLength̐lAbean̐̌ƂA
     * trueԋp邱ƁAG[bZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber17() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "12.12";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // ݒ
        Var varInteger = new Var();
        varInteger.setName("integerLength");
        varInteger.setValue("3");
        field.addVar(varInteger);
        // vw
        Var varIsAccordedInteger = new Var();
        varIsAccordedInteger.setName("isAccordedInteger");
        varIsAccordedInteger.setValue("");
        field.addVar(varIsAccordedInteger);
        // ݒ
        Var varScale = new Var();
        varScale.setName("scale");
        varScale.setValue(null);
        field.addVar(varScale);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateNumber18()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"12.12"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength="3"<br>
     *                var:isAccordedInteger=null<br>
     *                var:scale=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * integerLengthɐlAisAccordedIntegernullw肳ĂA
     * integerLength̐lAbean̐̌ƂA
     * trueԋp邱ƁAG[bZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber18() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "12.12";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // ݒ
        Var varInteger = new Var();
        varInteger.setName("integerLength");
        varInteger.setValue("3");
        field.addVar(varInteger);
        // vw
        Var varIsAccordedInteger = new Var();
        varIsAccordedInteger.setName("isAccordedInteger");
        varIsAccordedInteger.setValue(null);
        field.addVar(varIsAccordedInteger);
        // ݒ
        Var varScale = new Var();
        varScale.setName("scale");
        varScale.setValue(null);
        field.addVar(varScale);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateNumber19()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"12.12"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength="3"<br>
     *                var:isAccordedInteger="abc"<br>
     *                var:scale=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * integerLengthɐlAisAccordedIntegertrueł͂Ȃ񂪎w
     * ĂAintegerLength̐lAbean̐̌ƂA
     * trueԋp邱ƁAG[bZ[WǉȂƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber19() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "12.12";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // ݒ
        Var varInteger = new Var();
        varInteger.setName("integerLength");
        varInteger.setValue("3");
        field.addVar(varInteger);
        // vw
        Var varIsAccordedInteger = new Var();
        varIsAccordedInteger.setName("isAccordedInteger");
        varIsAccordedInteger.setValue("abc");
        field.addVar(varIsAccordedInteger);
        // ݒ
        Var varScale = new Var();
        varScale.setName("scale");
        varScale.setValue(null);
        field.addVar(varScale);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^Ă邱ƁB
        assertTrue(errors.isEmpty());
    }

//    /**
//     * testValidateNumber20()
//     * <br><br>
//     *
//     * (ُn)
//     * <br>
//     * ϓ_FF
//     * <br><br>
//     * ͒lF() bean:String:"abc"<br>
//     *         () va:not null<br>
//     *         () field:not null<br>
//     *                var:integerLength="2"<br>
//     *                var:scale=null<br>
//     *                Msg("message","message")<br>
//     *         () errors:not null<br>
//     *                (̗vf)<br>
//     *         () validator:not null<br>
//     *         () request:not null<br>
//     *
//     * <br>
//     * ҒlF(߂l) boolean:true<br>
//     *         (ԕω) errors:ActionMessage("message")<br>
//     *
//     * <br>
//     * integerLengthɐlw肳ĂAbeanlɕϊłȂꍇAfalseԋp邱ƁBG[bZ[Wǉ邱ƂmFB
//     * <br>
//     *
//     * @throws Exception ̃\bhŔO
//     */
//    public void testValidateNumber20() throws Exception {
//        //eXgP[X폜
//    }

    /**
     * testValidateNumber21()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"100.01"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength="3"<br>
     *                var:isAccordedInteger="true"<br>
     *                var:scale="2"<br>
     *                var:isAccordedScale="true"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * isAccordedInteger,isAccordedScaleƂtruêƂA
     * integerLengthƐAscaleƏ̌vĂ
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber21() throws Exception {

        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "100.01";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // ݒ
        Var varInteger = new Var();
        varInteger.setName("integerLength");
        varInteger.setValue("3");
        field.addVar(varInteger);
        // vw
        Var varIsAccordedInteger = new Var();
        varIsAccordedInteger.setName("isAccordedInteger");
        varIsAccordedInteger.setValue("true");
        field.addVar(varIsAccordedInteger);
        // ݒ
        Var varScale = new Var();
        varScale.setName("scale");
        varScale.setValue("2");
        field.addVar(varScale);
        // vݒ
        Var varIsAccordedScale = new Var();
        varIsAccordedScale.setName("isAccordedScale");
        varIsAccordedScale.setValue("true");
        field.addVar(varIsAccordedScale);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateNumber22()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"100.01"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength="4"<br>
     *                var:scale="3"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * ̌integerLengthŎw肳ꂽl菬A
     * scaleŎw肳ꂽl菬ꍇA
     * true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber22() throws Exception {

        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "100.01";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // ݒ
        Var varInteger = new Var();
        varInteger.setName("integerLength");
        varInteger.setValue("4");
        field.addVar(varInteger);
        // ݒ
        Var varScale = new Var();
        varScale.setName("scale");
        varScale.setValue("3");
        field.addVar(varScale);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[ɃG[IuWFNgo^ĂȂƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateNumber23()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map<br>
     *                ["field1"="100.01"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength="4"<br>
     *                var:scale="4"<br>
     *                property="field1"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beanString^ł͂ȂƂAfieldpropertyŎw肳ꂽ
     * vpeBɑ΂Č؂s邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber23() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "100.01");

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field1");
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // ݒ
        Var varInteger = new Var();
        varInteger.setName("integerLength");
        varInteger.setValue("4");
        field.addVar(varInteger);
        // ݒ
        Var varScale = new Var();
        varScale.setName("scale");
        varScale.setValue("4");
        field.addVar(varScale);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪒ǉĂȂ
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateNumber24()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map<br>
     *                ["field1"="100.01"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength="2"<br>
     *                var:scale="1"<br>
     *                property="field1"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * beanString^ł͂ȂƂAfieldpropertyŎw肳ꂽ
     * vpeBɑ΂Č؂s邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber24() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "100.01");

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field1");
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // ݒ
        Var varInteger = new Var();
        varInteger.setName("integerLength");
        varInteger.setValue("2");
        field.addVar(varInteger);
        // ݒ
        Var varScale = new Var();
        varScale.setName("scale");
        varScale.setValue("1");
        field.addVar(varScale);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[񂪒ǉĂ邱
        assertEquals(1, errors.size());

        // G[IuWFNǧ
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateNumber25()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map<br>
     *                ["field1"="100.01"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength="2"<br>
     *                var:scale="1"<br>
     *                property="field2"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beanString^ł͂ȂƂAfieldpropertyŎw肳ꂽ
     * vpeBɂ݂Ȃꍇ́Atrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber25() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "100.01");

        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field2");
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // ݒ
        Var varInteger = new Var();
        varInteger.setName("integerLength");
        varInteger.setValue("2");
        field.addVar(varInteger);
        // ݒ
        Var varScale = new Var();
        varScale.setName("scale");
        varScale.setValue("1");
        field.addVar(varScale);

        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪒ǉĂ邱
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateNumber03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"123.12"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:integerLength=null<br>
     *                var:scale=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * Sp̐l͂ꂽꍇA
     * G[bZ[Wǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateNumber26() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "PQR";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        Var var = new Var();
        var.setName("integerLength");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("scale");
        var.setValue(null);
        field.addVar(var);

        // G[
        ActionMessages errors = new ActionMessages();

        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();

        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateNumber(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);

        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[񂪒ǉĂ邱
        assertEquals(1, errors.size());

        // G[IuWFNǧ
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

}
