/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.util.ExceptionUtil;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.MockHttpSession;
import junit.framework.TestCase;

import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.impl.ModuleConfigImpl;

/**
 * RequestProcessorEx ubN{bNXeXgB<br>
 * O<br>
 * EprocessActionFormEx()\bh̊mF́AprocessActionForm()
 * \bhɓB<br>
 * 
 * @version 2004/03/18
 */
public class RequestProcessorExTest extends TestCase {

    /**
     * RXgN^B
     */
    public RequestProcessorExTest(String arg) {
        super(arg);
    }

    /**
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LogUTUtil.flush();
    }

    /**
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testProcess01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * req=HttpServletRequestCX^X<br>
     * res=not null<br>
     * 
     * Ғl
     * ߂l:void<br>
     * 
     * reqHttpServletRequest̃CX^X̎A
     * HttpServletRequestExɃbv邱Ɓ1<br>
     * 
     * @throws Exception O<br>
     */
    public void testProcess01() throws Exception {

        //eXgf[^ݒ

        // process()œnꂽNGXgIuWFNgԋppNX
        // process()ōŏɌĂ΂郁\bhAprocessPath()
        // nullԋp邱ƂɂAprocessPath()ȍ~̏i߂ȂB
        RequestProcessorEx_RequestProcessorExStub01 processor =
            new RequestProcessorEx_RequestProcessorExStub01();
        HttpServletRequest req = new MockHttpServletRequest();
        HttpServletResponse res = new MockHttpServletResponse();

        //eXgs
        processor.process(req, res);

        //eXgʊmF
        assertSame(processor.getRequestEx(), req);
    }

    /**
     * testProcess02B<br>
     * 
     * (ُn)<br>
     * ϓ_FG<br>
     * 
     * ͒l
     * req=not null<br>
     * res=not null<br>
     * 
     * Ғl
     * ߂l:void<br>
     * 
     * eNXprocess()IOExceptionX[ƂA
     * ̂܂܃X[邱<br>
     * 
     * @throws Exception O<br>
     */
    public void testProcess02() throws Exception {
        // process()œnꂽNGXgIuWFNgԋppNX
        // process()ōŏɌĂ΂郁\bhAprocessPath()
        // IOExceptionX[邱ƂɂAprocessPath()ȍ~̏
        // i߂ȂB
        RequestProcessorEx_RequestProcessorExStub02 processor =
            new RequestProcessorEx_RequestProcessorExStub02();
        HttpServletRequest req = new MockHttpServletRequest();
        HttpServletResponse res = new MockHttpServletResponse();

        try {
            //eXgs
            processor.process(req, res);
            fail();
        } catch (IOException e) {
            // Oo͂̊mFiIOExceptionj
            assertTrue(LogUTUtil.checkError(ExceptionUtil.getStackTrace(e)));
        }
    }

    /**
     * testProcess03B<br>
     * 
     * (ُn)<br>
     * ϓ_FG<br>
     * 
     * ͒l
     * req=not null<br>
     * res=not null<br>
     * 
     * Ғl
     * ߂l:void<br>
     * 
     * eNXprocess()ServletExceptionX[ƂA
     * ̂܂܃X[邱<br>
     * 
     * @throws Exception O<br>
     */
    public void testProcess03() throws Exception {
        // process()œnꂽNGXgIuWFNgԋppNX
        // process()ŌĂ΂郁\bhAprocessActionPerform()
        // ServletExceptionX[B
        // processActionForm()ɂǂ蒅܂ł̊ԁA
        // IĂ܂\bh͑SăI[oChB
        RequestProcessorEx_RequestProcessorExStub03 processor =
            new RequestProcessorEx_RequestProcessorExStub03();
        HttpServletRequest req = new MockHttpServletRequest();
        HttpServletResponse res = new MockHttpServletResponse();

        //eXgs
        try {
            processor.process(req, res);
            fail();
        } catch (ServletException e) {
            // Oo͂̊mFijavax.servlet.ServletExceptionj
            assertTrue(LogUTUtil.checkError(ExceptionUtil.getStackTrace(e)));
        }
    }

    /**
     * testProcess04B<br>
     * 
     * (ُn)<br>
     * ϓ_FG<br>
     * 
     * ͒l
     * req=not null<br>
     * res=not null<br>
     * 
     * Ғl
     * ߂l:void<br>
     * 
     * eNXprocess()IOExceptionAServletExceptionȊO
     * OX[ƂAServletExceptionɃbvA
     * X[邱<br>
     * 
     * @throws Exception O<br>
     */
    public void testProcess04() throws Exception {
        //eXgf[^ݒ

        // process()œnꂽNGXgIuWFNgԋppNX
        // process()ŌĂ΂郁\bhAprocessPath()
        // RuntimeExceptionX[B
        RequestProcessorEx_RequestProcessorExStub04 processor =
            new RequestProcessorEx_RequestProcessorExStub04();
        HttpServletRequest req = new MockHttpServletRequest();
        HttpServletResponse res = new MockHttpServletResponse();

        //eXgs
        try {
            processor.process(req, res);
            fail();
        } catch (ServletException e) {
            //eXgʊmF
            // ServletExceptionX[ꂽꍇ̂݃eXgB
            assertTrue(LogUTUtil.checkError(ExceptionUtil.getStackTrace(e.getRootCause())));
        }
    }

    /**
     * testProcessPopulate01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * req=p[^FcompanyId="companyId"<br>
     * res=not null<br>
     * form=not null<br>
     * mapping=not null<br>
     * request(SKIP_POPULATE)=null<br>
     * name="formName"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * SKIP_POPULATE=null<br>
     * form(tB[hl)=companyId="companyId"<br>
     * 
     * NGXgSKIP_POPULATEo^ĂȂꍇA
     * NGXgp[^tH[ɔfA
     * NGXgSKIP_POPULATEL[null̂܂܂łB<br>
     * 
     * @throws Exception O<br>
     */
    public void testProcessPopulate01() throws Exception {
        //eXgf[^ݒ
        RequestProcessorEx processor = new RequestProcessorEx();

        // [NGXgEX|X
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setParameter("companyId", "companyId");
        req.setAttribute(RequestProcessorEx.SKIP_POPULATE, null);

        HttpServletResponse res = new MockHttpServletResponse();
        RequestProcessorEx_ActionFormStub01 form =
            new RequestProcessorEx_ActionFormStub01();

        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("formName");

        processor.processPopulate(req, res, form, mapping);

        //eXgʊmF
        assertEquals("companyId", form.getCompanyId());
        assertNull(req.getAttribute(RequestProcessorEx.SKIP_POPULATE));
    }

    /**
     * testProcessPopulate02B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * req=p[^FcompanyId="companyId"<br>
     * res=not null<br>
     * form=not null<br>
     * mapping=not null<br>
     * request(SKIP_POPULATE)=""<br>
     * name="formName"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * SKIP_POPULATE=""<br>
     * form(tB[hl)=companyId="companyId"<br>
     * 
     * NGXgSKIP_POPULATEŋ󕶎o^A
     * tH[󕶎ł͂ȂƂANGXgp[^
     * tH[ɔfANGXgSKIP_POPULATE
     * L[͍폜B<br>
     * 
     * @throws Exception O<br>
     */
    public void testProcessPopulate02() throws Exception {
        //eXgf[^ݒ
        RequestProcessorEx processor = new RequestProcessorEx();

        // [NGXgEX|X
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setParameter("companyId", "companyId");
        req.setAttribute(RequestProcessorEx.SKIP_POPULATE, "");

        HttpServletResponse res = new MockHttpServletResponse();
        RequestProcessorEx_ActionFormStub01 form =
            new RequestProcessorEx_ActionFormStub01();

        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("formName");

        processor.processPopulate(req, res, form, mapping);

        //eXgʊmF
        assertEquals("companyId", form.getCompanyId());
        assertNull(req.getAttribute(RequestProcessorEx.SKIP_POPULATE));
    }

    /**
     * testProcessPopulate03B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * req=p[^FcompanyId="companyId"<br>
     * res=not null<br>
     * form=not null<br>
     * mapping=not null<br>
     * request(SKIP_POPULATE)="formName"<br>
     * name="formName"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * SKIP_POPULATE=null<br>
     * form(tB[hl)=companyId=null<br>
     * 
     * NGXgSKIP_POPULATEœo^ꂽtH[ƁA
     * ANV}bsÕtH[vĂƂA
     * NGXgp[^͔fꂸANGXg
     * SKIP_POPULATE͍폜ȂB<br>
     * 
     * @throws Exception O<br>
     */
    public void testProcessPopulate03() throws Exception {
        //eXgf[^ݒ
        RequestProcessorEx processor = new RequestProcessorEx();

        // [NGXgEX|X
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setParameter("companyId", "companyId");
        req.setAttribute(RequestProcessorEx.SKIP_POPULATE, "formName");

        HttpServletResponse res = new MockHttpServletResponse();
        RequestProcessorEx_ActionFormStub01 form =
            new RequestProcessorEx_ActionFormStub01();

        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("formName");

        processor.processPopulate(req, res, form, mapping);

        //eXgʊmF
        assertNull(form.getCompanyId());
        assertEquals(
            "formName",
            req.getAttribute(RequestProcessorEx.SKIP_POPULATE));
    }

    /**
     * testProcessPopulate04B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * req=p[^FcompanyId="companyId"<br>
     * res=not null<br>
     * form=not null<br>
     * mapping=not null<br>
     * request(SKIP_POPULATE)="anotherName"<br>
     * name="formName"<br>
     * 
     * Ғl
     * ߂l:void<br>
     * SKIP_POPULATE="anotherName"<br>
     * form(tB[hl)=companyId="companyId"<br>
     * 
     * NGXgSKIP_POPULATEœo^ꂽtH[ƁA
     * ANV}bsÕtH[vĂȂƂA
     * NGXgp[^͔fANGXg
     * SKIP_POPULATE͍폜B<br>
     * 
     * @throws Exception O<br>
     */
    public void testProcessPopulate04() throws Exception {
        //eXgf[^ݒ
        RequestProcessorEx processor = new RequestProcessorEx();

        // [NGXgEX|X
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setParameter("companyId", "companyId");
        req.setAttribute(RequestProcessorEx.SKIP_POPULATE, "anotherName");

        HttpServletResponse res = new MockHttpServletResponse();
        RequestProcessorEx_ActionFormStub01 form =
            new RequestProcessorEx_ActionFormStub01();

        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("formName");

        processor.processPopulate(req, res, form, mapping);

        //eXgʊmF
        assertEquals("companyId", form.getCompanyId());
        assertNull(req.getAttribute(RequestProcessorEx.SKIP_POPULATE));
    }

    /**
     * testProcessPopulate05B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * req=p[^FcompanyId="companyId"<br>
     * res=not null<br>
     * form=not null<br>
     * mapping=not null<br>
     * request(SKIP_POPULATE)=null<br>
     * name="formName"<br>
     * cancelPopulate=true<br>
     * 
     * Ғl
     * ߂l:void<br>
     * SKIP_POPULATE=null<br>
     * form(tB[hl)=companyId=null<br>
     * 
     * ActionMappingEx̑cancelPopulatetruêƂA
     * NGXgp[^͔fꂸA
     * NGXgSKIP_POPULATEL[null̂܂܂łB<br>
     * 
     * @throws Exception O<br>
     */
    public void testProcessPopulate05() throws Exception {
        //eXgf[^ݒ
        RequestProcessorEx processor = new RequestProcessorEx();

        // [NGXgEX|X
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setParameter("companyId", "companyId");
        req.setAttribute(RequestProcessorEx.SKIP_POPULATE, null);

        HttpServletResponse res = new MockHttpServletResponse();
        RequestProcessorEx_ActionFormStub01 form =
            new RequestProcessorEx_ActionFormStub01();

        ActionMappingEx mapping = new ActionMappingEx();
        mapping.setName("formName");
        mapping.setCancelPopulate(true);

        processor.processPopulate(req, res, form, mapping);

        //eXgʊmF
        assertNull(form.getCompanyId());
        assertNull(req.getAttribute(RequestProcessorEx.SKIP_POPULATE));
    }

    /**
     * testProcessActionForm01B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * req=not null<br>
     * res=not null<br>
     * mapping=ActionMappingCX^X<br>
     * scope="session"<br>
     * name="_formName"<br>
     * 
     * Ғl
     * ߂l:form=ActionFormԋp<br>
     * session="_anothorForm"폜Ȃ<br>
     * 
     * ̃ANV}bsOActionMappingEx
     * ̃CX^Xł͂ȂA
     * super.processActionForm()Ă΂Ă邱ƁB<br>
     */
    public void testProcessActionForm01() throws Exception {

        RequestProcessorEx processor = new RequestProcessorEx();
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockHttpSession session = new MockHttpSession();
        
        //eXgf[^ݒ
        // eXgsɂ́AModuleConfigݒ肷KvB
        ModuleConfig config = new ModuleConfigImpl("");
        processor.init(null, config);

        // [NGXgEX|X
        session.setAttribute("_anotherForm", new DynaActionForm());

        // [ZbVNGXgɓo^
        req.setSession(session);

        // Struts̃ANV}bsOp
        ActionMapping normalMapping = new ActionMapping();
        normalMapping.setScope("session");
        normalMapping.setName("_formName");

        //eXgs
        processor.processActionForm(req, res, normalMapping);

        //eXgʊmF
        assertNotNull(session.getAttribute("_anotherForm"));
    }

    /**
     * testProcessActionForm02B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * req=not null<br>
     * res=not null<br>
     * mapping=ActionMappingExCX^X<br>
     * scope=null<br>
     * name=null<br>
     * 
     * Ғl
     * ߂l:form=ActionFormԋp<br>
     * session="_anothorForm"폜Ȃ<br>
     * 
     * XR[vnull̎Asuper.processActionForm()
     * Ă΂Ă邱ƁB<br>
     */
    public void testProcessActionForm02() throws Exception {
        //eXgf[^ݒ
        RequestProcessorEx processor = new RequestProcessorEx();
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockHttpSession session = new MockHttpSession();
        ActionMappingEx mapping = new ActionMappingEx();

        // [NGXgEX|X
        session.setAttribute("_anotherForm", new DynaActionForm());

        // [ZbVNGXgɓo^
        req.setSession(session);

        mapping.setScope(null);
        mapping.setName(null);

        // ActionFormUtil.clearForm()ɕKvȐݒ(ݒ)
        //mapping.setClearForm("_formName");

        //eXgs
        processor.processActionForm(req, res, mapping);

        //eXgʊmF
        assertNotNull(session.getAttribute("_anotherForm"));
    }

    /**
     * testProcessActionForm03B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * req=not null<br>
     * res=not null<br>
     * mapping=not null<br>
     * scope="(request)"<br>
     * name=null<br>
     * 
     * Ғl
     * ߂l:form=ActionFormԋp<br>
     * session="_anothorForm"폜Ȃ<br>
     * 
     * XR[v"session"ȊO̎̕A
     * super.processActionForm()Ă΂Ă邱ƁB<br>
     */
    public void testProcessActionForm03() throws Exception {
        //eXgf[^ݒ
        RequestProcessorEx processor = new RequestProcessorEx();
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockHttpSession session = new MockHttpSession();
        ActionMappingEx mapping = new ActionMappingEx();
        
        // [NGXgEX|X
        session.setAttribute("_anotherForm", new DynaActionForm());

        // [ZbVNGXgɓo^
        req.setSession(session);

        mapping.setScope("request");
        mapping.setName(null);

        // ActionFormUtil.clearForm()ɕKvȐݒiݒj
        // mapping.setClearForm("_formName");

        //eXgs
        processor.processActionForm(req, res, mapping);

        //eXgʊmF
        assertNotNull(session.getAttribute("_anotherForm"));
    }

    /**
     * testProcessActionForm04B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * req=not null<br>
     * res=not null<br>
     * mapping=not null<br>
     * scope="session"<br>
     * name=null<br>
     * 
     * Ғl
     * ߂l:form=ActionFormԋp<br>
     * session="_anothorForm"폜Ȃ<br>
     * 
     * tH[null̎Asuper.processActionForm()
     * Ă΂Ă邱ƁB<br>
     */
    public void testProcessActionForm04() throws Exception {
        //eXgf[^ݒ
        RequestProcessorEx processor = new RequestProcessorEx();
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockHttpSession session = new MockHttpSession();
        ActionMappingEx mapping = new ActionMappingEx();

        session.setAttribute("_anotherForm", new DynaActionForm());

        // [ZbVNGXgɓo^
        req.setSession(session);

        mapping.setScope("session");
        mapping.setName(null);

        // ActionFormUtil.clearForm()ɕKvȐݒiݒj
        // mapping.setClearForm("_formName");

        //eXgs
        processor.processActionForm(req, res, mapping);

        //eXgʊmF
        assertNotNull(session.getAttribute("_anotherForm"));
    }

    /**
     * testProcessActionForm05B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * req=not null<br>
     * res=not null<br>
     * mapping=not null<br>
     * scope="session"<br>
     * name="(formName)"<br>
     * 
     * Ғl
     * ߂l:form=ActionFormԋp<br>
     * session="_anothorForm"폜Ȃ<br>
     * 
     * tH[̐擪A_[XRAł͂ȂA
     * super.processActionForm()Ă΂Ă邱ƁB<br>
     */
    public void testProcessActionForm05() throws Exception {
        //eXgf[^ݒ
        RequestProcessorEx processor = new RequestProcessorEx();
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockHttpSession session = new MockHttpSession();
        ActionMappingEx mapping = new ActionMappingEx();

        // eXgsɂ́AModuleConfigݒ肷KvB
        ModuleConfig config = new ModuleConfigImpl("");
        processor.init(null, config);

        // [NGXgEX|X
        session.setAttribute("_anotherForm", new DynaActionForm());

        // [ZbVNGXgɓo^
        req.setSession(session);

        mapping.setScope("session");
        mapping.setName("formName");

        // ActionFormUtil.clearForm()ɕKvȐݒiݒj
        // mapping.setClearForm("_formName");

        //eXgs
        processor.processActionForm(req, res, mapping);

        //eXgʊmF
        assertNotNull(session.getAttribute("_anotherForm"));
    }

    /**
     * testProcessActionForm06B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * req=not null<br>
     * res=not null<br>
     * mapping=not null<br>
     * scope="session"<br>
     * name="_(_formName)"<br>
     * clearForm=true<br>
     * 
     * Ғl
     * ߂l:form=ActionFormԋp<br>
     * session=_anothorForm폜邱<br>
     * 
     * tH[̐擪A_[XRAł鎞A
     * processActionFormEx()Ă΂A"_"t̃tH[Sč폜
     * Ă邱ƁB<br>
     */
    public void testProcessActionForm06() throws Exception {

        //eXgf[^ݒ
        RequestProcessorEx processor = new RequestProcessorEx();
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockHttpSession session = new MockHttpSession();
        ActionMappingEx mapping = new ActionMappingEx();

        // eXgsɂ́AModuleConfigݒ肷KvB
        ModuleConfig config = new ModuleConfigImpl("");
        processor.init(null, config);

        // [NGXgEX|X
        session.setAttribute("_formName", new DynaActionForm());
        session.setAttribute("_anotherForm", new DynaActionForm());

        // [ZbVNGXgɓo^
        req.setSession(session);

        mapping.setScope("session");
        mapping.setName("_formName");
        mapping.setClearForm(true);

        // ActionFormUtil.clearForm()ɕKvȐݒ
        mapping.setClearForm(true);

        //eXgs
        processor.processActionForm(req, res, mapping);

        //eXgʊmF
        assertNull(session.getAttribute("_formName"));
        assertNull(session.getAttribute("_anotherForm"));
    }

    /**
     * testProcessActionForm07B<br>
     * 
     * (n)<br>
     * ϓ_FA<br>
     * 
     * ͒l
     * req=not null<br>
     * res=not null<br>
     * mapping=not null<br>
     * scope="session"<br>
     * name="_(_formName)"<br>
     * clearForm=false<br>
     * 
     * Ғl
     * ߂l:form=ActionFormԋp<br>
     * session=_anothorForm폜Ă邱<br>
     * 
     * tH[̐擪A_[XRAł鎞A
     * processActionFormEx()Ă΂A"_"t̃tH[ŁA
     * ݃ANV}bsOŎw肳ĂtH[ȊÔ̂폜
     * Ă邱ƁB<br>
     */
    public void testProcessActionForm07() throws Exception {

        //eXgf[^ݒ
        RequestProcessorEx processor = new RequestProcessorEx();
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        MockHttpSession session = new MockHttpSession();
        ActionMappingEx mapping = new ActionMappingEx();

        // eXgsɂ́AModuleConfigݒ肷KvB
        ModuleConfig config = new ModuleConfigImpl("");
        processor.init(null, config);

        // [NGXgEX|X
        session.setAttribute("_formName", new DynaActionForm());
        session.setAttribute("_anotherForm", new DynaActionForm());

        // [ZbVNGXgɓo^
        req.setSession(session);

        mapping.setScope("session");
        mapping.setName("_formName");
        mapping.setClearForm(true);

        // ActionFormUtil.clearForm()ɕKvȐݒ
        mapping.setClearForm(false);

        //eXgs
        processor.processActionForm(req, res, mapping);

        //eXgʊmF
        //ANV}bsOɓo^ĂtH[͍폜ȂƁB
        assertNotNull(session.getAttribute("_formName"));
        assertNull(session.getAttribute("_anotherForm"));
    }
}
