/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.database.service;

import java.util.Map;

import jp.terasoluna.thin.functionsample.database.bean.AddressTableVO;
import jp.terasoluna.fw.dao.UpdateDAO;

/**
 * VKf[^o^T[rXB
 *
 */
public class ResultInsertAddressServiceImpl 
                        implements ResultInsertAddressService {

    /**
     * Z^ꗗ擾T[rX
     */
    protected ListAddressService listAddressService = null;
    
    /**
     * VKo^pDAONXB
     * SpringɂCX^Xݒ肳B
     */
    protected UpdateDAO updateDAO = null;

    /**
     * Z^e[uɐVKf[^o^B
     *
     * @param aParam o^Z
     * @return Z^ꗗ
     */
    public Map<String, Object> insertAddress(AddressTableVO aParam) {
        
        Map<String, Object> listAddress = null;
        
        // VKo^
        int count = updateDAO.execute("database.insertAddress", aParam);
        if (count != 0) {
            listAddress = listAddressService.getListAddress();
        }
        
        return listAddress;
    }

    /**
     * listAddressService擾B
     * @return listAddressService
     */
    public ListAddressService getListAddressService() {
        return listAddressService;
    }

    /**
     * listAddressServiceݒ肷B
     * @param listAddressService listAddressServiceB
     */
    public void setListAddressService(ListAddressService listAddressService) {
        this.listAddressService = listAddressService;
    }

    /**
     * updateDAO擾B
     * @return updateDAO
     */
    public UpdateDAO getUpdateDAO() {
        return updateDAO;
    }

    /**
     * updateDAOݒ肷B
     * @param updateDAO updateDAOB
     */
    public void setUpdateDAO(UpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }
}