package jp.terasoluna.rich.tutorial.service.common.message;

import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.ApplicationObjectSupport;

/**
 * エラーメッセージのアクセスクラス
 *
 */
public class MessageAccessorImpl extends ApplicationObjectSupport implements
        MessageAccessor {

    @Override
    public String getMessage(String errorCode) {
        return getMessage(errorCode, null);
    }

    @Override
    public String getMessage(String errorCode, String[] options) {
        return getMessageSourceAccessor().getMessage(errorCode, options);
    }

    @Override
    public String getMessage(MessageSourceResolvable resolvable) {
        return getMessageSourceAccessor().getMessage(resolvable);
    }

}