package jp.terasoluna.rich.tutorial.service.common.exception;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * Terasoluna Client FW for .NET 3.0によるクライアントでの例外ハンドリングを考慮した
 * FaultBeanのサンプル実装クラス。<br>
 * SoapFaultのdetail要素に含まれるエラー情報を定義する。
 *
 */
@XmlRootElement(name = "SampleSoapFault", namespace = "http://jp.terasoluna.toursample")
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SampleSoapFault", namespace = "http://jp.terasoluna.toursample")
public class SampleFaultBean {

    @XmlElement(name = "ErrorType", namespace = "http://jp.terasoluna.toursample")
    private String errorType;
    @XmlElement(name = "BizLogicErrorType", namespace = "http://jp.terasoluna.toursample")
    private String bizLogicErrorType;
    @XmlElement(name = "ErrorMessages", namespace = "http://jp.terasoluna.toursample")
    private ErrorMessages errorMessages;

    public String getErrorType() {
        return errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public String getBizLogicErrorType() {
        return bizLogicErrorType;
    }

    public void setBizLogicErrorType(String bizLogicErrorType) {
        this.bizLogicErrorType = bizLogicErrorType;
    }

    public ErrorMessages getErrorMessages() {
        return errorMessages;
    }

    public void setErrorMessages(ErrorMessages errorMessages) {
        this.errorMessages = errorMessages;
    }
}
