﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using CalcWcfBusinessApplication.Dto;
using System.IO;
using System.Web;
using CalcWcfBusinessApplication.Properties;
using Microsoft.Practices.EnterpriseLibrary.Validation.Integration.WCF;


namespace CalcWcfBusinessApplication.Service
{
    // メモ: ここでクラス名 "MtomService" を変更する場合は、App.config で "MtomService" への参照も更新する必要があります。
    /// <summary>
    /// MTOMを使ったファイルアップロード、ダウンロードのサンプル
    /// </summary>
    [ServiceContract]
    public class MtomService
    {
        /// <summary>
        /// ダウンロードファイル名
        /// </summary>
        private static readonly string DOWNLOAD_FILENAME_PATH = 
            HttpRuntime.AppDomainAppPath + "File\\";

        #region IMtomService メンバ

        /// <summary>
        /// ファイルをアップロードする
        /// </summary>
        /// <param name="trasferdFile"></param>
        [OperationContract]
        public void Upload(TransferedFile transferdFile)
        {
            string filePath = Path.GetTempPath() + "Uploaded_" + transferdFile.FileName;
            File.WriteAllBytes(filePath, transferdFile.FileData);
        }

        /// <summary>
        /// ファイルをダウンロードする
        /// </summary>
        /// <param name="inputDto"></param>
        /// <returns></returns>
        [OperationContract]
        ///サーバ側入力値検証の設定
        [ValidationBehavior(RuleSet = "RS01")] 
        public TransferedFile Download(DownloadInputDto inputDto)
        {
            string filePath = DOWNLOAD_FILENAME_PATH + inputDto.FileName;
            TransferedFile downloadFile = new TransferedFile();
            if (File.Exists(filePath))
            {                
                downloadFile.FileName = inputDto.FileName;
                downloadFile.FileData = File.ReadAllBytes(filePath);            
            }
            else
            {
                throw new FileNotFoundException(string.Format(Resources.ERROR_MTOM_MSG001, filePath));
            }
            return downloadFile;
        }

        #endregion
    }
}
