﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using Microsoft.Practices.Unity;
using CalcWcfBusinessApplication.Dto;
using Terasoluna.ServiceModel;
using Terasoluna.BizLogic;
using Terasoluna.ExceptionHandling;
using System.Transactions;
using System.Threading;
using CalcDBAccess.CalcDataSetTableAdapters;
using CalcDBAccess;
using Terasoluna.DataCopy;
using CalcWcfBusinessApplication.Properties;
using Microsoft.Practices.EnterpriseLibrary.Validation.Integration.WCF;


namespace CalcWcfBusinessApplication.Service
{
    // メモ: ここでクラス名 "CalcService" を変更する場合は、App.config で "CalcService" への参照も更新する必要があります。
    /// <summary>
    /// 通常のWCFサービスのサンプル
    /// </summary>
    [ServiceContract]
    public class CalcService
    {
        /// <summary>
        /// DIインスタンスの注入が可能
        /// UnityContainerをDIした例
        /// </summary>
        [Dependency]
        public IUnityContainer Container { get; set; }

        /// <summary>
        /// 足し算する
        /// </summary>
        /// <param name="inputDto"></param>
        /// <returns></returns>
        [OperationContract]
        ///サーバ側入力値検証の設定
        [ValidationBehavior(RuleSet = "RS01")]
        public CalcOutputDto Add(CalcInputDto inputDto)
        {
            //Thread.Sleep(5000); 
            int result = inputDto.Num1 + inputDto.Num2;
            return new CalcOutputDto() { Answer = result };
        }

        /// <summary>
        /// ログインする
        /// </summary>
        /// <param name="inputDto"></param>
        [OperationContract]
        ///サーバ側入力値検証の設定
        [ValidationBehavior(RuleSet = "RS01")]
        public void Login(LoginInputDto inputDto)
        {            
            ///自動トランザクションの設定
            using (TransactionScope scope = new TransactionScope())
            {
                UserTableAdapter ta = new UserTableAdapter();
                CalcDataSet ds = new CalcDataSet();
                ta.FillByIdAndPassword(ds.User, inputDto.UserId, inputDto.Password);
                if (ds.User.Count == 0)
                {
                    ///IDとパスワードが合致しなかった場合
                    ///業務エラーとしてBizLogicExceptionをスロー
                    throw new BizLogicException(
                        BizLogicExceptionErrorType.BizLogicFailure,
                        Resources.ERROR_CALC_MSG002,
                        new List<ErrorInfo>()
                        {
                            new ErrorInfo("ERROR_CALC_MSG003", null, 
                                Resources.ERROR_CALC_MSG003, null)
                        });
                }

                ///(参考)POCOとDataSet間のコピーの例                
                ///ログイン処理には不要な処理
                SampleDto copiedData = DataCopyManager.CreateCopy<SampleDto>(ds);
            }            
        }

    }

    /// <summary>
    /// （参考）上記のPOCOとDataSet間のコピーの例のためのDTO
    /// ログイン処理には不要なクラス
    /// </summary>
    public class SampleDto
    {
        public List<UserDto> User { get; set; }
    }

    public class UserDto
    {
        public string Id { get; set; }
        public string Password { get; set; }
    }

}
