﻿using CalcDBAccess.CalcDataSetTableAdapters;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using CalcDBAccess;

namespace CalcDBAccess.UT
{
    
    
    /// <summary>
    ///UserTableAdapterTest のテスト クラスです。すべての
    ///UserTableAdapterTest 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    [DeploymentItem("CalcDBForSql2008.mdf")]
    public class UserTableAdapterTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        ///FillByIdAndPassword のテスト
        ///id、passwordが該当するユーザを取得できること
        ///</summary>
        [TestMethod()]
        public void FillByIdAndPasswordTest01()
        {
            string id = "terasoluna";
            string password = "password";
            UserTableAdapter target = new UserTableAdapter();
            CalcDataSet.UserDataTable dataTable = new CalcDataSet.UserDataTable();            
            target.FillByIdAndPassword(dataTable, id, password);
            Assert.AreEqual(1, dataTable.Count);
            Assert.AreEqual(id, dataTable[0].Id);
            Assert.AreEqual(password, dataTable[0].Password);            
        }

        /// <summary>
        ///FillByIdAndPassword のテスト
        ///idが合致しないためユーザを取得できないこと
        ///</summary>
        [TestMethod()]
        public void FillByIdAndPasswordTest02()
        {
            string id = "hoge";
            string password = "password";
            UserTableAdapter target = new UserTableAdapter();
            CalcDataSet.UserDataTable dataTable = new CalcDataSet.UserDataTable();
            target.FillByIdAndPassword(dataTable, id, password);
            Assert.AreEqual(0, dataTable.Count);            
        }

        /// <summary>
        ///FillByIdAndPassword のテスト
        ///passwordが合致しないためユーザを取得できないこと
        ///</summary>
        [TestMethod()]
        public void FillByIdAndPasswordTest03()
        {
            string id = "terasoluna";
            string password = "hoge";
            UserTableAdapter target = new UserTableAdapter();
            CalcDataSet.UserDataTable dataTable = new CalcDataSet.UserDataTable();
            target.FillByIdAndPassword(dataTable, id, password);
            Assert.AreEqual(0, dataTable.Count);
        }

    }
}
