﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.DataCopy;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.Windows.Forms.FormForward;
using Terasoluna.Windows.Forms.MessageNotification;
using Terasoluna.Windows.ViewModel;

// ViewDataクラスを作成後、正しい名前空間を指定しコメントアウトして下さい。
using CalcBusinessApplication.ViewData;
using Terasoluna.Windows.Forms.Events;

namespace CalcBusinessApplication.View
{
    // ScreenIdが決定後、指定して下さい。
    [ScreenId("LoginView")]
    public partial class LoginView : Form
    {
        // ViewDataクラスを作成後、コメントアウトして下さい。
        public LoginViewData ViewData { get; set; }

        public LoginView()
        {
            InitializeComponent();
            // ViewDataクラスを作成後、コメントアウトして下さい。
            ViewData = ValidatableViewDataManager.CreateViewData<LoginViewData>();
        }

        private void LoginView_Load(object sender, EventArgs e)
        {
            // バインディングソース名が確定したら、修正後コメントアウトして下さい。
            loginViewDataBindingSource.DataSource = ViewData;
            // 初期表示
            ViewData.UserId = "terasoluna";
            ViewData.Password = "password";
        }   
        
        /// <summary>
        /// ログインボタン押下時
        /// </summary>
        private void loginButton_Click(object sender, EventArgs e)
        {
            if (clientBizRadioButton.Checked)
            {
                EventProcessResult result = clientBizEventProcessWorker.RunWorker();
                if (result.IsSuccess)
                {
                    Hide();
                    formForwarderToMenuView.Forward();
                }
            }
            else if (wcfRadioButton.Checked)
            {
                wcfEventProcessWorker.RunWorkerAsync();
            }            
        }
        
        /// <summary>
        /// 遷移先画面がクローズ
        /// </summary>
        private void formForwarderToMenuView_ForwardFormClosed(object sender, ForwardFormClosedEventArgs e)
        {
            if (e.CloseState == FormState.Closed)
            {

                ///初期画面はFormFowarder管理外の画面のため、
                ///FormForwardManager.Reshowメソッドは使用せずForm.Showメソッドを実行
                Show();
            }
        }
        
        /// <summary>
        /// イベント処理完了時
        /// </summary>
        private void wcfEventProcessWorker_Completed(object sender, EventProcCompletedEventArgs e)
        {
            if (e.Result.IsSuccess)
            {
                Hide();
                ///画面遷移
                formForwarderToMenuView.Forward();
            }
        }
    }
}
