﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.DataCopy;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.Windows.Forms.FormForward;
using Terasoluna.Windows.Forms.MessageNotification;
using Terasoluna.Windows.ViewModel;

// ViewDataクラスを作成後、正しい名前空間を指定しコメント化を解除して下さい。
using CalcBusinessApplication.ViewData;
using CalcBusinessApplication.Dto;
using System.IO;
using CalcWinFormsApp.View;
using CalcBusinessApplication.Properties;

namespace CalcBusinessApplication.View
{
    // ScreenIdが決定後、指定して下さい。
    [ScreenId("FileDownloadView")]
    public partial class FileDownloadView : Form
    {
        // ViewDataクラスを作成後、コメント化を解除して下さい。
        public FileDownloadViewData ViewData { get; set; }

        public FileDownloadView()
        {
            InitializeComponent();
            // ViewDataクラスを作成後、コメント化を解除して下さい。
            ViewData = ValidatableViewDataManager.CreateViewData<FileDownloadViewData>();
        }

        private void FileDownloadView_Load(object sender, EventArgs e)
        {
            // バインディングソース名が確定したら、修正後コメント化を解除して下さい。
            fileDownloadViewDataBindingSource.DataSource = ViewData;
        }

        /// <summary>
        /// ダウンロード(Stream)ボタン押下時
        /// </summary>
        private void downloadByStreamButton_Click(object sender, EventArgs e)
        {
            //イベントの非同期実行
            downloadByStreamEventProcessWorker.RunWorkerAsync();
            ///ちなみに、ビジネスロジックのInputDtoとOutputDtoのクラスが同じであるため
            ///OutputDtoのFileNameプロパティが画面データを上書きしないように
            ///ResponseDataReflecttion/Mapping/ResponseSourceIngnorePropertyPathsを設定している
        }

        /// <summary>
        /// ダウンロード(byte[])ボタン押下時
        /// </summary>
        private void downloadByByteArrayButton_Click(object sender, EventArgs e)
        {
            //イベントの非同期実行
            downloadByByteArrayEventProcessWorker.RunWorkerAsync();
            ///ちなみに、ビジネスロジックのInputDtoとOutputDtoのクラスが同じであるため
            ///OutputDtoのFileNameプロパティが画面データを上書きしないように
            ///ResponseDataReflecttion/Mapping/ResponseSourceIngnorePropertyPathsを設定している

        }


        /// <summary>
        /// イベント処理完了時
        /// </summary>
        private void eventProcessWorker_Completed(object sender, Terasoluna.Windows.Forms.Events.EventProcCompletedEventArgs e)
        {
            string tempFileName = null;
            if (e.Result.IsSuccess)
            {
                ///ダウンロードに成功した場合
                FileInfoDto outputDto = e.Result.BizLogicResult as FileInfoDto;
                tempFileName = outputDto.FileName;
                if (string.IsNullOrEmpty(tempFileName))
                {
                    return;
                }
                saveFileDialog1.FileName = Path.GetFileName(tempFileName);
                DialogResult result = saveFileDialog1.ShowDialog();
                if (result == DialogResult.OK)
                {
                    string outputFileName = saveFileDialog1.FileName;
                    File.Copy(tempFileName, outputFileName, true);
                    MessageNotifier.ShowInformationMessage(this, Resources.INFO_MTOM_MSG002);
                }
            }
            ///一時ファイルの削除
            if (!string.IsNullOrEmpty(tempFileName))
            {
                File.Delete(tempFileName);
            }
        }
    }
}
