﻿using CalcBusinessApplication.BizLogic;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using CalcBusinessApplication.Dto;
using System;
using Terasoluna.BizLogic;
using Terasoluna;

namespace CalcBusinessApplication.UT
{
    
    
    /// <summary>
    ///LoginBizLogicTest のテスト クラスです。すべての
    ///LoginBizLogicTest 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    [DeploymentItem("TerasolunaBootstrap.config")]
    [DeploymentItem("TerasolunaFramework.config")]
    [DeploymentItem("TerasolunaApplication.config")]
    [DeploymentItem("CalcBusinessApplication.config")]
    public class LoginBizLogicTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        [ClassInitialize()]
        public static void MyClassInitialize(TestContext testContext)
        {
            TerasolunaFramework.Run();
        }
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        [ClassCleanup()]
        public static void MyClassCleanup()
        {
            TerasolunaFramework.Exit();
        }
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        ///Login のテストの例
        ///UserIDとPasswordが正しい場合にログインに成功すること
        ///</summary>
        [TestMethod()]
        public void LoginTest01()
        {
            string userId = "terasoluna";
            string password = "password";
            LoginBizLogic target = new LoginBizLogic();
            LoginInputDto input = new LoginInputDto() { UserId = userId, Password = password };
            try
            {
                target.Login(input);                
            }
            catch (Exception e)
            {
                Assert.Fail(e.Message);
            }
        }

        /// <summary>
        ///Login のテストの例
        ///UserIDが異なる場合に業務エラー(ERROR_CALC_MSG003)になること
        ///</summary>
        [TestMethod()]
        public void LoginTest02()
        {
            string userId = "hoge";
            string password = "password";
            LoginBizLogic target = new LoginBizLogic();
            LoginInputDto input = new LoginInputDto() { UserId = userId, Password = password };
            try
            {
                target.Login(input);
                Assert.Fail("入力チェックエラーが発生しませんでした");
            }
            catch (BizLogicException e)
            {
                Assert.AreEqual("BizLogicFailure", e.ErrorType);
                Assert.AreEqual(1, e.Errors.Count);
                Assert.AreEqual("ERROR_CALC_MSG003", e.Errors[0].ErrorId);
                Assert.AreEqual("ユーザIDまたはパスワードに誤りがあります。", e.Errors[0].Message);
            }
            catch (Exception e)
            {
                Assert.Fail(e.Message);
            }
        }

        /// <summary>
        ///Login のテストの例
        ///Passwordが異なる場合に業務エラー(ERROR_CALC_MSG003)になること
        ///</summary>
        [TestMethod()]
        public void LoginTest03()
        {
            string userId = "hoge";
            string password = "password";
            LoginBizLogic target = new LoginBizLogic();
            LoginInputDto input = new LoginInputDto() { UserId = userId, Password = password };
            try
            {
                target.Login(input);
                Assert.Fail("入力チェックエラーが発生しませんでした");
            }
            catch (BizLogicException e)
            {
                Assert.AreEqual("BizLogicFailure", e.ErrorType);
                Assert.AreEqual(1, e.Errors.Count);
                Assert.AreEqual("ERROR_CALC_MSG003", e.Errors[0].ErrorId);
                Assert.AreEqual("ユーザIDまたはパスワードに誤りがあります。", e.Errors[0].Message);
            }
            catch (Exception e)
            {
                Assert.Fail(e.Message);
            }
        }
    }
}
