package jp.terasoluna.toursample.server.common.exception;

/**
 *
 * 業務エラー発生時にスローする例外クラス。
 *
 */
public class ApplicationException extends Exception {

    private static final long serialVersionUID = 4913561519645832864L;
    private String errorCode = null;
    private String[] options = null;
    private String message = null;

    public ApplicationException(Throwable cause) {
        super(cause);
        this.errorCode = "";
    }

    public ApplicationException(Throwable cause, String errorCode) {
        super(cause);
        this.errorCode = errorCode;
    }

    public ApplicationException(Throwable cause, String errorCode,
            String[] optionStrings) {
        super(cause);
        this.errorCode = errorCode;
        this.options = optionStrings;
    }

    public ApplicationException(Throwable cause, String errorCode, String s0) {
        super(cause);
        this.errorCode = errorCode;
        this.options = new String[] { s0 };
    }

    public ApplicationException(Throwable cause, String errorCode, String s0,
            String s1) {
        super(cause);
        this.errorCode = errorCode;
        this.options = new String[] { s0, s1 };
    }

    public ApplicationException(Throwable cause, String errorCode, String s0,
            String s1, String s2) {
        super(cause);
        this.errorCode = errorCode;
        this.options = new String[] { s0, s1, s2 };
    }

    public ApplicationException(Throwable cause, String errorCode, String s0,
            String s1, String s2, String s3) {
        super(cause);
        this.errorCode = errorCode;
        this.options = new String[] { s0, s1, s2, s3 };
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String[] getOptions() {
        return this.options;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getMessage() {
        if (this.message == null) {
            return this.errorCode;
        }
        return this.message;
    }
}
