package jp.terasoluna.toursample.server.common.code;

import java.sql.SQLException;
import java.sql.Types;

import com.ibatis.sqlmap.client.extensions.ParameterSetter;
import com.ibatis.sqlmap.client.extensions.ResultGetter;
import com.ibatis.sqlmap.client.extensions.TypeHandlerCallback;

/**
 * RoleEnum用のTypeHandlerCallback
 *
 */
public class RoleEnumTypeHandler implements TypeHandlerCallback {

    @Override
    public Object getResult(ResultGetter getter) throws SQLException {
        return valueOf(getter.getString());
    }

    @Override
    public void setParameter(ParameterSetter setter, Object param)
            throws SQLException {
        if (param == null) {
            setter.setNull(Types.VARCHAR);
        } else {
            RoleEnum value = (RoleEnum) param;
            setter.setString(value.toString());
        }

    }

    @Override
    public Object valueOf(String str) {
        return RoleEnum.valueOf(str);
    }

}
