package jp.terasoluna.toursample.server.b01.bizlogic;

import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.toursample.server.b01.dto.B01_02_03_S01InputDto;
import jp.terasoluna.toursample.server.common.exception.ApplicationException;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;

public class B01_02BizLogicImpl implements B01_02BizLogic {

    // サンプルのデフォルトは、MockDAOになっているので、DB接続したい場合は、
    // h2dbフォルダ内にあるH2DBを動作させること
    // また、環境設定手順の詳細はプロジェクト直下のreadme_h2db.txtを参照のこと
    @Autowired
    private UpdateDAO updateDAO;

    @Override
    public void executeB01_02_03_S01(B01_02_03_S01InputDto input)
            throws ApplicationException {
        // ユーザの登録
        try {
            updateDAO.execute("B01.insertUser", input);
        } catch (DataIntegrityViolationException e) {
            // 主キーの重複
            // 業務エラー用の例外(ApplicationExcpeition)をスロー
            throw new ApplicationException(e, "WARN_B01_02_0001");
        }

    }

}
