package jp.terasoluna.toursample.server.a01.service;

import javax.activation.DataHandler;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.xml.ws.soap.MTOM;

import jp.terasoluna.toursample.server.a01.bizlogic.A01_02BizLogic;
import jp.terasoluna.toursample.server.a01.dto.A01_02_01_S02InputDto;
import jp.terasoluna.toursample.server.a01.dto.A01_02_01_S03InputDto;
import jp.terasoluna.toursample.server.a01.dto.A01_02_01_S03OutputDto;
import jp.terasoluna.toursample.server.common.exception.SampleSoapFaultException;
import jp.terasoluna.toursample.server.common.exception.handler.SampleSoapFaultExceptionHandler;
import jp.terasoluna.toursample.server.common.mtom.StreamBody;
import jp.terasoluna.toursample.server.common.validation.SampleValidator;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

/**
 *
 * MTOMを使ったアップロード/ダウンロードのWebサービスサンプル
 * SpringBeanAutowiringSupportを継承し作成する
 */
@MTOM
@WebService(serviceName = "A01_02MtomService")
public class A01_02MtomService extends SpringBeanAutowiringSupport {
    @Autowired
    private A01_02BizLogic bizLogic;
    @Autowired
    private SampleSoapFaultExceptionHandler exceptionHandler;
    @Autowired
    @Qualifier("defaultValidator")
    private SampleValidator defaultValidator;

    /**
     * WCFクライアント側でStreamでファイルダウンロードを扱うサンプル
     * メソッドの引数をStreamBodyを１つだけもつようにしないとクライアント側はbyte[]になってしまう。
     * このため、ストリームといっしょにテキスト情報を送ることができない
     */
    @WebMethod(operationName = "ExecuteA01_02_01_S02")
    public StreamBody executeA01_02_01_S02(A01_02_01_S02InputDto inputDto)
            throws SampleSoapFaultException {
        try {
            // 入力チェック処理の実施
            defaultValidator.validate(inputDto);
            DataHandler dataHandler = bizLogic.executeA01_02_01_S02(inputDto);
            // Streamデータの作成
            StreamBody streamBody = new StreamBody();
            streamBody.setStream(dataHandler);
            return streamBody;
        } catch (Exception e) {
            // 例外が発生した場合に、必要に応じてSampleSoapFaultExceptionをスロー
            exceptionHandler.handleException(e);
        }
        return null;
    }

    /**
     * WCFクライアント側でByte配列でファイルダウンロードを扱うサンプル
     * バイトデータ以外にも、テキスト情報も一緒に送れる
     */
    @WebMethod(operationName = "ExecuteA01_02_01_S03")
    public A01_02_01_S03OutputDto executeA01_02_01_S03(
            A01_02_01_S03InputDto inputDto) throws SampleSoapFaultException {
        try {
            // 入力チェック処理の実施
            defaultValidator.validate(inputDto);
            return bizLogic.executeA01_02_01_S03(inputDto);
        } catch (Exception e) {
            // 例外が発生した場合に、必要に応じてSampleSoapFaultExceptionをスロー
            exceptionHandler.handleException(e);
        }
        return null;

    }
}
