package jp.terasoluna.toursample.server.a01.service;

import javax.jws.WebMethod;
import javax.jws.WebService;

import jp.terasoluna.toursample.server.a01.bizlogic.A01_01BizLogic;
import jp.terasoluna.toursample.server.a01.dto.A01_01_01_S01InputDto;
import jp.terasoluna.toursample.server.common.exception.SampleSoapFaultException;
import jp.terasoluna.toursample.server.common.exception.handler.SampleSoapFaultExceptionHandler;
import jp.terasoluna.toursample.server.common.validation.SampleValidator;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

/**
 *
 * 通常のWebサービスのサンプル
 * SpringBeanAutowiringSupportを継承し作成する
 *
 */
@WebService(serviceName = "A01_01Service", targetNamespace = "http://jp.terasoluna.toursample")
public class A01_01Service extends SpringBeanAutowiringSupport {

    @Autowired
    private A01_01BizLogic bizLogic;
    @Autowired
    private SampleSoapFaultExceptionHandler exceptionHandler;
    @Autowired
    @Qualifier("a01_01_01_C01Validator")
    private SampleValidator a01_01_01_C01Validator;


    /**
     * ツアー情報を登録する
     * @param input
     * @throws SampleSoapFaultException
     */
    @WebMethod(operationName = "ExecuteA01_01_01_S01")
    public void executeA01_01_01_S01(A01_01_01_S01InputDto input)
            throws SampleSoapFaultException {
        try {
            // 入力チェック処理の実施
            a01_01_01_C01Validator.validate(input);
            // ビジネスロジックの実施
            bizLogic.executeA01_01_01_S01(input);
        } catch (Exception e) {
            // 例外が発生した場合に、必要に応じてSampleSoapFaultExceptionをスロー
            exceptionHandler.handleException(e);
        }
    }


}
