package jp.terasoluna.toursample.server.a01.bizlogic;

import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.toursample.server.a01.dto.A01_01_01_S01ConductorDto;
import jp.terasoluna.toursample.server.a01.dto.A01_01_01_S01DeptPlaceDto;
import jp.terasoluna.toursample.server.a01.dto.A01_01_01_S01InputDto;
import jp.terasoluna.toursample.server.a01.dto.A01_01_01_S01TourCategoryDto;
import jp.terasoluna.toursample.server.common.exception.ApplicationException;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;

public class A01_01BizLogicImpl implements A01_01BizLogic {

    // サンプルのデフォルトは、MockDAOになっているので、DB接続したい場合は、
    // h2dbフォルダ内にあるH2DBを動作させること
    // また、環境設定手順の詳細はプロジェクト直下のreadme_h2db.txtを参照のこと
    @Autowired
    private UpdateDAO updateDAO;

    @Override
    public void executeA01_01_01_S01(A01_01_01_S01InputDto input)
            throws ApplicationException {

        // ツアーの登録
        try {
            updateDAO.execute("A01.insertTour", input.getTour());

            // 担当者の登録
            String tourCode = input.getTour().getTourCode();
            if (input.getConductorList() != null) {
                for (A01_01_01_S01ConductorDto conductor : input
                        .getConductorList()) {
                    conductor.setTourCode(tourCode);
                    updateDAO.execute("A01.insertConductor", conductor);
                }
            }
            if (input.getTour().getDeptPlaceList() != null) {
                for (A01_01_01_S01DeptPlaceDto deptPlace : input.getTour()
                        .getDeptPlaceList()) {
                    deptPlace.setTourCode(tourCode);
                    updateDAO.execute("A01.insertTourDept", deptPlace);
                }
            }
            if (input.getTour().getTourCategoryList() != null) {
                for (A01_01_01_S01TourCategoryDto category : input.getTour()
                        .getTourCategoryList()) {
                    category.setTourCode(tourCode);
                    updateDAO.execute("A01.insertTourCategory", category);
                }
            }
        } catch (DataIntegrityViolationException e) {
            // 主キーの重複
            // 業務エラー用の例外(ApplicationExcpeition)をスロー
            throw new ApplicationException(e, "WARN_A01_01_0001");
        }
    }

}
