package jp.terasoluna.toursample.server.mock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.toursample.server.domain.model.Tour;

import org.springframework.dao.DataIntegrityViolationException;

/**
 * DBの代わりのダミーのデータストア
 */
public class TourDataStore {

    private static TourDataStore singleton = new TourDataStore();
    private Map<String, Tour> map = new HashMap<String, Tour>();

    private TourDataStore() {

    }

    public static TourDataStore getInstance() {
        return singleton;
    }

    public void insert(Tour tour) {
        if (map.containsKey(tour.getTourCode())) {
            // DB上での主キーの重複を想定したダミーの例外
            throw new DataIntegrityViolationException("すでに存在するTourCodeです。");
        }
        map.put(tour.getTourCode(), tour);
    }

    public Tour findKey(String tourCode) {
        return map.get(tourCode);
    }

    public List<Tour> findByName(String tourName) {
        ArrayList<Tour> list = new ArrayList<Tour>();

        for (Tour tour : map.values()) {
            if (tour.getName() != null && tour.getName().startsWith(tourName)) {
                list.add(tour);
            }
        }
        sort(list);
        return list;
    }

    /**
     * ツアーコードでソート
     */
    private void sort(List<Tour> list) {
        Collections.sort(list, new Comparator<Tour>() {
            public int compare(Tour tour1, Tour tour2) {
                String tour1Code = tour1.getTourCode();
                String tour2Code = tour2.getTourCode();
                if (tour1Code.compareTo(tour2Code) < 0) {
                    return -1;
                } else if (tour1Code.compareTo(tour2Code) > 0) {
                    return 1;
                }
                return 0;
            }
        });

    }

}
