package jp.terasoluna.toursample.server.interfaces.ws.mtom;

import javax.activation.DataHandler;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

/**
 *
 * WCFクライアント側でMTOMによる通信で、Streamとして扱えるようにするサンプル実装
 * namespaceに、"http://schemas.microsoft.com/Message"を設定する必要がある
 *
 */
@XmlType(name = "StreamBody", namespace = "http://schemas.microsoft.com/Message")
public class StreamBody {
    private DataHandler stream;

    @XmlValue
    @XmlMimeType("application/octet-stream")
    public DataHandler getStream() {
        return stream;
    }

    public void setStream(DataHandler stream) {
        this.stream = stream;
    }

}
