package jp.terasoluna.toursample.server.interfaces.usermanage.assembler;

import jp.terasoluna.toursample.server.domain.code.RoleEnum;
import jp.terasoluna.toursample.server.domain.model.User;
import jp.terasoluna.toursample.server.interfaces.usermanage.dto.UserDto;

/**
 * UserクラスのAssembler
 *
 */
public class UserAssembler {

    public UserDto toSummaryDto(User user) {
        RoleEnum enumOfDomain = user.getRole();
        jp.terasoluna.toursample.server.interfaces.usermanage.code.RoleEnum enumOfDto = null;
        if (enumOfDomain != null) {
            enumOfDto = jp.terasoluna.toursample.server.interfaces.usermanage.code.RoleEnum
                    .valueOf(enumOfDomain.toString());
        }
        return new UserDto(user.getId(), user.getName(), enumOfDto);
    }

    public User fromDto(UserDto dto) {
        jp.terasoluna.toursample.server.interfaces.usermanage.code.RoleEnum enumOfDto = dto
                .getRole();
        RoleEnum enumOfDomain = null;
        if (enumOfDto != null) {
            enumOfDomain = RoleEnum.valueOf(enumOfDto.toString());
        }
        if (dto.getUserDetail() != null) {
            return new User(dto.getId(), dto.getPassword(), dto.getName(), enumOfDomain, dto
                            .getUserDetail().getEmail(), dto.getUserDetail()
                    .getAddress(),
                    dto.getUserDetail().getCompanyName(), dto.getVersion());
        } else {
            return new User(dto.getId(), dto.getPassword(), dto.getName(), enumOfDomain, null, null,
                    null, dto.getVersion());
        }
    }

}
