package jp.terasoluna.toursample.server.interfaces.tour.assembler;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.toursample.server.domain.code.TourTypeEnum;
import jp.terasoluna.toursample.server.domain.code.TransportationEnum;
import jp.terasoluna.toursample.server.domain.model.Tour;
import jp.terasoluna.toursample.server.interfaces.tour.dto.TourDto;
import jp.terasoluna.toursample.server.interfaces.tour.dto.TourSummaryCollection;
import jp.terasoluna.toursample.server.interfaces.tour.dto.TourSummaryListDto;
import jp.terasoluna.toursample.server.interfaces.tour.dto.TourSummaryListTourDto;
import jp.terasoluna.toursample.server.interfaces.ws.mtom.FileObjectDto;
import jp.terasoluna.toursample.server.interfaces.ws.mtom.StreamBody;

/**
 * TourクラスのAssembler
 *
 */
public class TourAssembler {
    // ファイルの保存先
    private static final String TEMP_DIR = "C:\\tmp\\";

    public TourSummaryListTourDto toSummaryDto(Tour tour) {
        return new TourSummaryListTourDto(tour.getTourCode(), tour.getName(), tour
                .getDestName());
    }

    public TourSummaryListDto toSummaryListDto(List<Tour> tourList) {
        if (tourList == null) {
            return null;
        }
        ArrayList<TourSummaryListTourDto> dtoList = new ArrayList<TourSummaryListTourDto>();
        for (Tour tour : tourList) {
            dtoList.add(toSummaryDto(tour));
        }
        return new TourSummaryListDto(new TourSummaryCollection(dtoList));
    }

    public Tour fromDto(TourDto dto) {
        jp.terasoluna.toursample.server.interfaces.tour.code.TransportationEnum transportationEnumOfDto = dto
                .getTransportation();
        TransportationEnum transportationEnumOfDomain = null;
        if (transportationEnumOfDto != null) {
            transportationEnumOfDomain = TransportationEnum
                    .valueOf(transportationEnumOfDto.toString());
        }

        jp.terasoluna.toursample.server.interfaces.tour.code.TourTypeEnum tourTypeEnumOfDto = dto
                .getTourType();
        TourTypeEnum tourTypeEnumOfDomain = null;
        if (tourTypeEnumOfDto != null) {
            tourTypeEnumOfDomain = TourTypeEnum.valueOf(tourTypeEnumOfDto
                    .toString());
        }

        return new Tour(dto.getTourCode(), dto.getName(),
                tourTypeEnumOfDomain,
                transportationEnumOfDomain,
                new TourCategoryAssembler().fromDtoList(dto.getTourCategoryList()),
                new DeptPlaceAssembler().fromDtoList(dto.getDeptPlaceList()),
                dto.getDestName(),
                dto.getDeptDate(),
                dto.getTourDay(),
                new ConductorAssembler().fromDtoList(dto.getConductorList()),
                dto.isHasOptionalTour(),
                new HotelRankAssembler().fromDto(dto.getHotelRank()),
                dto.getVersion());

    }

    //現状、ダミーのファイルを返却する処理
    public StreamBody toStreamBody(List<Tour> tourList) {
        File file = new File(TEMP_DIR + "downloadFileWithStream.dat");
        // テストデータを書き込んだダウンロードファイルの作成
        Writer writer = null;
        try {
            file.createNewFile();
            writer = new OutputStreamWriter(new BufferedOutputStream(
                    new FileOutputStream(file)), "UTF-8");
            writer.write("テスト");
        } catch (IOException e) {
            throw new SystemException(e);
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e) {
                    throw new SystemException(e);
                }
            }
        }
        // Streamデータの作成
        StreamBody streamBody = new StreamBody();
        streamBody.setStream(new DataHandler(new FileDataSource(file)));
        return streamBody;
    }

    //ダミーのファイルを返却する処理
    public FileObjectDto toTourListFileDto(List<Tour> tourList) {
        // テストデータを書き込んだダウンロードファイルの作成
        Writer writer = null;
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            writer = new OutputStreamWriter(new BufferedOutputStream(bos),
                    "UTF-8");
            writer.write("テスト2");
        } catch (IOException e) {
            throw new SystemException(e);
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e) {
                    throw new SystemException(e);
                }
            }
        }
        // ファイル名の設定
        FileObjectDto outputDto = new FileObjectDto();
        if (bos != null) {
            outputDto.setFileData(bos.toByteArray());
            outputDto.setFileName("出力結果.txt");
        }
        return outputDto;
    }

}
