package jp.terasoluna.toursample.server.interfaces.tour.assembler;

import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.toursample.server.domain.model.Conductor;
import jp.terasoluna.toursample.server.interfaces.tour.dto.ConductorDto;

/**
 * ConductorクラスのAssembler
 *
 */
public class ConductorAssembler {

    public ConductorDto toDto(Conductor conductor) {
        return new ConductorDto(conductor.getId(), conductor.getName(),
                conductor.getEmail(), conductor.getVersion());
    }

    public List<ConductorDto> toDtoList(List<Conductor> conductorList) {
        if (conductorList == null) {
            return null;
        }
        ArrayList<ConductorDto> dtoList = new ArrayList<ConductorDto>();
        for (Conductor conductor : conductorList) {
            dtoList.add(toDto(conductor));
        }
        return dtoList;
    }

    public Conductor fromDto(ConductorDto dto) {
        return new Conductor(dto.getId(), dto.getName(), dto.getEmail(), dto
                .getVersion());
    }

    public List<Conductor> fromDtoList(List<ConductorDto> dtoList) {
        if (dtoList == null) {
            return null;
        }
        ArrayList<Conductor> conductorList = new ArrayList<Conductor>();
        for (ConductorDto dto : dtoList) {
            conductorList.add(fromDto(dto));
        }
        return conductorList;
    }
}
