package jp.terasoluna.toursample.server.application.usermanage.impl;

import jp.terasoluna.toursample.server.application.exception.ApplicationException;
import jp.terasoluna.toursample.server.application.usermanage.UserManageBizLogic;
import jp.terasoluna.toursample.server.domain.model.User;
import jp.terasoluna.toursample.server.domain.model.UserRepository;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;

public class UserManageBizLogicImpl implements UserManageBizLogic {
    @Autowired
    private UserRepository userRepository;

    @Override
    public void addUser(User user) throws ApplicationException {
        // ドメインロジックの実行例（中身はダミー）
        user.doSomething();
        try {
            userRepository.store(user);
        } catch (DataIntegrityViolationException e) {
            // 主キーの重複
            throw new ApplicationException(e, "WARN_B01_02_0001");
        }
    }

    @Override
    public User login(User user) throws ApplicationException {

        User result = userRepository.findByIdAndPass(user);
        if (result == null)
        {
            ///ユーザ名またはパスワードが一致しない場合
            throw new ApplicationException(null, "WARN_B01_01_0001");
        }
        return result;
    }
}
