package jp.terasoluna.toursample.server.application.tour.impl;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

import javax.activation.DataHandler;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.toursample.server.application.exception.ApplicationException;
import jp.terasoluna.toursample.server.application.tour.TourBizLogic;
import jp.terasoluna.toursample.server.domain.model.DeptPlace;
import jp.terasoluna.toursample.server.domain.model.Tour;
import jp.terasoluna.toursample.server.domain.model.TourCategory;
import jp.terasoluna.toursample.server.domain.model.TourRepository;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;

public class TourBizLogicImpl implements TourBizLogic {
    // ファイルの保存先
    private static final String TEMP_DIR = "C:\\tmp\\";

    @Autowired
    private TourRepository tourRepository;

    @Override
    public void addTour(Tour tour) throws ApplicationException {

        // ドメインロジックの実行例（中身はダミー）
        tour.doSomething();
        try {
            tourRepository.store(tour);
        } catch (DataIntegrityViolationException e) {
            // 主キーの重複
            throw new ApplicationException(e, "WARN_A01_01_0001");
        }
    }

    @Override
    public List<Tour> findTourByName(String tourName)
            throws ApplicationException {
        return tourRepository.findByTourName(tourName);
    }

    @Override
    public void addRegistTourJob(String fileName, byte[] fileData) {
        //ローカルにファイル保存するだけのダミー処理
        OutputStream os = null;
        try {
            // ファイル名を取得しファイルデータを保存
            os = new BufferedOutputStream(new FileOutputStream(TEMP_DIR
                    + fileName));
            os.write(fileData);
        } catch (IOException e) {
            throw new SystemException(e);
        } finally {
            if (os != null) {
                try {
                    os.close();
                } catch (IOException e) {
                    throw new SystemException(e);
                }
            }
        }

    }

    @Override
    public void addRegistTourJob(DataHandler dataHandler) {
        //ローカルにファイル保存するだけのダミー処理
        InputStream is = null;
        OutputStream os = null;
        try {
            is = dataHandler.getInputStream();
            // ファイルの保存
            os = new BufferedOutputStream(new FileOutputStream(TEMP_DIR
                    + "uploadfileWithStream.dat"));

            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = is.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
        } catch (IOException e) {
            throw new SystemException(e);
        } finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            } catch (IOException e) {
                throw new SystemException(e);
            }
        }
    }

    @Override
    public List<DeptPlace> findAllDeptPlaces() throws ApplicationException {
        return tourRepository.findAllDeptPlaces();
    }

    @Override
    public List<TourCategory> findAllTourCategories()
            throws ApplicationException {
        return tourRepository.findAllCategories();
    }

}
