package jp.terasoluna.toursample.server.application.message;

import org.springframework.context.MessageSourceResolvable;

/**
 * エラーメッセージアクセス用のインタフェース
 *
 */
public interface MessageAccessor {

    /**
     * メッセージを取得する
     *
     * @param errorCode
     * @return
     */
    public String getMessage(String errorCode);

    /**
     * メッセージを取得する
     *
     * @param errorCode
     *            エラーコード
     * @param options
     *            置換文字列
     * @return メッセージ、メッセージを生成出来なかった場合にはエラーコード
     */
    public String getMessage(String errorCode, String[] options);

    /**
     * メッセージを取得する
     *
     * @param resolvable
     * @return メッセージ、メッセージを生成出来なかった場合にはエラーコード
     */
    public String getMessage(MessageSourceResolvable resolvable);
}