﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Terasoluna.TourSample.Client.Common.Code;

namespace Terasoluna.TourSample.Client.Common.CommonData
{
    /// <summary>
    /// アプリケーション全体の共通データ領域
    /// </summary>
    public class ApplicationCommonData
    {
        //Singletonパターン
        private static readonly ApplicationCommonData singleton = new ApplicationCommonData();

        private ApplicationCommonData()
        {
        }

        public static ApplicationCommonData Instance
        {
            get
            {
                return singleton;
            }
        }
        
        /// <summary>
        /// ユーザID    
        /// </summary>
        public string UserId { get; set; }

        /// <summary>
        /// ユーザ権限
        /// </summary>
        public RoleEnum Role { get; set; }

    }
}
