﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.Windows.Forms.FormForward;
using Terasoluna.TourSample.Client.Common.View;
using Terasoluna.TourSample.Client.B01.ViewData;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.TourSample.Client.Common.CommonData;

namespace Terasoluna.TourSample.Client.B01.View
{
    /// <summary>
    /// メニュー画面
    /// </summary>
    [ScreenId("SC_B01_01_02")]
    public partial class SC_B01_01_02View : TourSampleViewBase
    {
        /// <summary>
        /// 画面データ
        /// </summary>
        public SC_B01_01_02ViewData ViewData { get; set; }

        public SC_B01_01_02View()
        {
            InitializeComponent();
            ViewData = ValidatableViewDataManager.CreateViewData<SC_B01_01_02ViewData>();
        }

        private void SC_B01_01_02View_Load(object sender, EventArgs e)
        {
            sC_B01_01_02ViewDataBindingSource.DataSource = ViewData;            
            //管理者権限時のみ、ユーザ管理業務を有効にする
            bool isAdmin = ApplicationCommonData.Instance.Role ==
                Terasoluna.TourSample.Client.Common.Code.RoleEnum.Admin;
            forwardSC_B01_02_00Button.Enabled = isAdmin;
            forwardSC_B01_03_01Button.Enabled = isAdmin;
        }

        /// <summary>
        /// ツアー情報登録ボタン押下時
        /// </summary>
        private void forwardSC_A01_01_01Button_Click(object sender, EventArgs e)
        {
            formForwarderToSC_A01_01_01.Forward();
        }

        /// <summary>
        /// ツアー情報検索・ダウンロードボタン押下時
        /// </summary>
        private void forwardSC_A01_02_01Button_Click(object sender, EventArgs e)
        {            
            formForwarderToSC_A01_02_01.Forward();         
        }

        /// <summary>
        /// ツアー情報アップロードボタン押下時
        /// </summary>
        private void forwardSC_A01_03_01Button_Click(object sender, EventArgs e)
        {
            formForwarderToSC_A01_03_01.Forward();
        }

        /// <summary>
        /// ファイルチェック処理ボタン押下時
        /// </summary>
        private void forwardSC_A01_04_01Button_Click(object sender, EventArgs e)
        {
            formForwarderToSC_A01_04_01.Forward();
        }

        /// <summary>
        /// ユーザ管理(ShowAndHide)ボタン押下時
        /// </summary>
        private void forwardSC_B01_02_00Button_Click(object sender, EventArgs e)
        {
            formForwarderToSC_B01_02_00.Forward();
        }

        /// <summary>
        /// ユーザ管理(パネル切り替え）
        /// </summary>
        private void forwardSC_B01_03_01Button_Click(object sender, EventArgs e)
        {
            formForwarderToSC_B01_03_01.Forward();
        }
    }
}
