﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.Windows.Forms.FormForward;
using Terasoluna.TourSample.Client.Common.View;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.TourSample.Client.B01.ViewData;
using Terasoluna.Windows.Forms.Events;
using Terasoluna.TourSample.Client.Common.CommonData;
using Terasoluna.TourSample.Client.Common.UserManageServiceReference;
using Terasoluna.DataCopy;



namespace Terasoluna.TourSample.Client.B01.View
{
    /// <summary>
    /// ログイン画面
    /// </summary>
    [ScreenId("SC_B01_01_01")]
    public partial class SC_B01_01_01View : TourSampleViewBase
    {
        /// <summary>
        /// 画面データ
        /// </summary>
        public SC_B01_01_01ViewData ViewData { get; set; }

        public SC_B01_01_01View()
        {
            InitializeComponent();
            ///画面データの生成
            ViewData = ValidatableViewDataManager.CreateViewData<SC_B01_01_01ViewData>();
        }

        private void SC_B01_01_01View_Load(object sender, EventArgs e)
        {
            ///バインド設定
            sC_B01_01_01ViewDataBindingSource.DataSource = ViewData;
            ViewData.User.Id = "terasoluna";
            ViewData.User.Password = "password";
        }

        /// <summary>
        /// ログインボタン押下
        /// </summary>
        private void loginButton_Click(object sender, EventArgs e)
        {
            ///イベント処理実行
            b01_01_01_C01EventProcessWorker.RunWorkerAsync();
        }

        /// <summary>
        /// 要求データ生成直後
        /// </summary>
        private void b01_01_01_C01EventProcessWorker_BuiltRequest(object sender, RequestDataBuiltEventArgs e)
        {
            //階層がずれた場合のコピー
            DataCopyManager.Copy(ViewData.User, e.RequestData);
        }

        /// <summary>
        /// 応答データ反映直後
        /// </summary>
        private void b01_01_01_C01EventProcessWorker_ReflectedResponse(object sender, ResponseDataReflectedEventArgs e)
        {
            //階層がずれた場合のコピー
            //DTOの戻り値がNameプロパティのみコピー
            MappingInfo mappingInfo = new MappingInfo();
            mappingInfo.DestinationTargetPropertyPaths.Add("Name");
            DataCopyManager.Copy(e.ResponseData, ViewData.User, mappingInfo);
        }

        /// <summary>
        /// 遷移先画面クローズ時
        /// </summary>
        private void formForwarderToSC_B01_01_02_ForwardFormClosed(object sender, ForwardFormClosedEventArgs e)
        {
            if (e.CloseState == FormState.Closed)
            {
                ///再表示されたときに引き継ぎデータを消去
                ViewData.User.Name = null;
                ///メニュー画面がCloseされたときに再表示（Show)する
                Show();
            }
        }

        /// <summary>
        /// ログインボタン押下時のイベント処理完了時
        /// </summary>
        private void b01_01_01_C01EventProcessWorker_Completed(object sender, EventProcCompletedEventArgs e)
        {
            if (e.Result.IsSuccess)
            {
                ///共通領域への直接値を代入する例
                ApplicationCommonData.Instance.UserId = ViewData.User.Id;
                UserDto outputDto = e.Result.BizLogicResult as UserDto;
                if (outputDto != null)
                {
                    ///Role（ユーザ権限情報）のコピー
                    ApplicationCommonData.Instance.Role = (Terasoluna.TourSample.Client.Common.Code.RoleEnum)
                        Enum.Parse(typeof(Terasoluna.TourSample.Client.Common.Code.RoleEnum), outputDto.Role.ToString());
                }
                ///ログイン成功時は、画面遷移                
                ///初期画面をCloseするとAP終了してしまうので非表示（Hide）する
                Hide();
                formForwarderToSC_B01_01_02.Forward();
            }
        }
        
    }
}
