﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.TourSample.Client.Common.View;
using Terasoluna.TourSample.Client.A01.ViewData;
using Terasoluna.Windows.Forms.FormForward;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.Windows.Forms.Events;

namespace Terasoluna.TourSample.Client.A01.View
{
    /// <summary>
    /// 担当者情報追加画面
    /// </summary>
    [ScreenId("SC_A01_01_02")]
    public partial class SC_A01_01_02View : TourSampleViewBase
    {
        /// <summary>
        /// 画面データ
        /// </summary>
        public SC_A01_01_02ViewData ViewData { get; set; }

        public SC_A01_01_02View()
        {
            InitializeComponent();
            ViewData = ValidatableViewDataManager.CreateViewData<SC_A01_01_02ViewData>();
        }

        private void SC_A01_01_02View_Load(object sender, EventArgs e)
        {
            sC_A01_01_02ViewDataBindingSource.DataSource = ViewData;
        }

        /// <summary>
        /// OKボタン押下時
        /// </summary>
        private void okButton_Click(object sender, EventArgs e)
        {
            EventProcessResult result = a01_01_02_C01EventProcessWorker.RunWorker();

            if (result.IsSuccess)
            {
                ///入力チェック処理を実施するため、
                ///イベント成功時のみDialogResult.OKにする
                this.DialogResult = DialogResult.OK;
                ///ShowWindowModalのときはCloseまたはHideが必要
                ///ShowApplicationModalのときは、不要
                Close();
            }
        }

        /// <summary>
        /// キャンセルボタン押下時
        /// </summary>
        private void cancelButton_Click(object sender, EventArgs e)
        {
            ///ShowApplicationModalの場合、通常
            ///キャンセルボタンは、DialogResultプロパティにCancelをセットするため、
            ///Clickイベントの実装は不要である。
            ///
            ///ShowWindowModalの場合は、DialogResultの設定と
            ///ClickイベントでCloseする必要がある
            this.DialogResult = DialogResult.Cancel;
            Close();
        }

    }
}
