﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;

namespace Terasoluna.TourSample.Client.Common.VirusCheck
{
    /// <summary>
    /// ウィルスチェック処理のためのインタフェース
    /// </summary>
    public interface IVirusChecker
    {
        /// <summary>
        /// 進捗通知イベント
        /// </summary>
        event EventHandler<ProgressChangedEventArgs> ProgressChanged;

        /// <summary>
        /// ファイルチェック
        /// </summary>
        VirusCheckResult CheckFile(String filePath);

        /// <summary>
        /// ディレクトリ配下に存在するファイルをチェックする
        /// </summary>
        List<VirusCheckResult> CheckFiles(String dirPath);
    }
}
