﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Terasoluna.SelectableValues;
using Microsoft.Practices.Unity;
using Terasoluna.TourSample.Client.Common.CodeListServiceReference;
using System.ServiceModel;
using Terasoluna.ServiceModel;
using Terasoluna.DataCopy;
using System.Collections;

namespace Terasoluna.TourSample.Client.Common.BizLogic
{
    /// <summary>
    /// コードリストを取得するビジネスロジック
    /// </summary>
    public class CodeListBizLogic
    {    
        /// <summary>
        /// エンドポイント名
        /// </summary>
        private const string EndpointName = "CodeListServicePort";

        /// <summary>
        /// UnityContainer
        /// </summary>
        [Dependency]
        public IUnityContainer Container { get; set; }

        /// <summary>
        /// 出発地のコードリストを取得
        /// </summary>
        /// <returns></returns>
        public IList<Terasoluna.SelectableValues.SelectableValue> GetDeptPlaceList()
        {
            List<Terasoluna.SelectableValues.SelectableValue> codeList = 
                new List<Terasoluna.SelectableValues.SelectableValue>();
            CodeListServiceClient client = null;
            try
            {
                ///エンドポイントアドレスの取得
                ///WCF接続先変更機能により、接続先サーバアドレスを一律置換してくれる。
                EndpointAddress address = CommunicationManager.GetReplacedEndpointAddress(Container, EndpointName);
                client = new CodeListServiceClient(EndpointName, address);
                CodeListServiceReference.SelectableValue[]
                    result = client.GetDeptPlaceList();
                client.Close();
                if (result != null)
                {
                    foreach (CodeListServiceReference.SelectableValue selectableValue in result)
                    {
                        codeList.Add(new Terasoluna.SelectableValues.SelectableValue(
                            selectableValue.DiplayName, selectableValue.Value));
                    }
                }
            }
            catch (System.Exception)
            {
                if (client != null)
                {
                    client.Abort();
                }
                throw;
            }
            return codeList;
        }

        /// <summary>
        /// ツアー分類のコードリストを取得
        /// </summary>
        /// <returns></returns>
        public IList<Terasoluna.SelectableValues.SelectableValue> GetTourCategoryList()
        {
            List<Terasoluna.SelectableValues.SelectableValue> codeList =
                new List<Terasoluna.SelectableValues.SelectableValue>();
            CodeListServiceClient client = null;
            try
            {
                ///エンドポイントアドレスの取得
                ///WCF接続先変更機能により、接続先サーバアドレスを一律置換してくれる。
                EndpointAddress address = CommunicationManager.GetReplacedEndpointAddress(Container, EndpointName);
                client = new CodeListServiceClient(EndpointName, address);
                CodeListServiceReference.SelectableValue[]
                    result = client.GetTourCategoryList();
                client.Close();
                if (result != null)
                {
                    foreach (CodeListServiceReference.SelectableValue selectableValue in result)
                    {
                        codeList.Add(new Terasoluna.SelectableValues.SelectableValue(
                            selectableValue.DiplayName, selectableValue.Value));
                    }
                }
            }
            catch (System.Exception)
            {
                if (client != null)
                {
                    client.Abort();
                }
                throw;
            }
            return codeList;
        }

    }
}
