﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using Terasoluna.Windows.ViewModel.Validation;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using Terasoluna.TourSample.Client.Common.Code;
using Terasoluna.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using Terasoluna.TourSample.Client.Properties;


namespace Terasoluna.TourSample.Client.B01.ViewData
{
    /// <summary>
    /// ユーザ登録画面(1/3)パネルの画面データクラス（ルート）
    /// </summary>
    [HasSelfValidation]
    [DefaultRuleset("RS01")]    
    public partial class SC_B01_03_01ViewData : ValidatableRootViewData
    {
        public SC_B01_03_01ViewData()
        {
            Role = RoleEnum.User.ToString();
        }

        [DisplayName("名前")]
        [RequiredValidator(Tag = "名前", Ruleset = "RS01")]
        [ZenkakuStringValidator(Tag = "名前", Ruleset = "RS01")]
        public virtual string UserName { get; set; }
        
        [DisplayName("ユーザID")]
        [RequiredValidator(Tag = "ユーザID", Ruleset = "RS01")]
        [AlphaNumericStringValidator(Tag = "ユーザID", Ruleset = "RS01")]
        public virtual string UserId { get; set; }
        
        [DisplayName("パスワード")]
        [RequiredValidator(Tag = "パスワード", Ruleset = "RS01")]
        [AlphaNumericStringValidator(Tag = "パスワード", Ruleset = "RS01")]
        public virtual string Password { get; set; }

        [DisplayName("確認用パスワード")]
        [RequiredValidator(Tag = "確認用パスワード", Ruleset = "RS01")]
        [AlphaNumericStringValidator(Tag = "確認用パスワード", Ruleset = "RS01")]
        public virtual string ConfirmPassword { get; set; }

        [DisplayName("ユーザ権限")]
        public virtual string Role { get; set; }

        /// <summary>
        /// ログインユーザ
        /// 
        /// メインのパネルの外のヘッダー領域に表示する
        /// </summary>
        public virtual SC_B01_03LoginUser LoginUser { get; set; }

        [SelfValidation(Ruleset="RS01")]
        private void CustomValidate01(ValidationResults results)
        {
            if (!string.Equals(Password, ConfirmPassword, StringComparison.Ordinal))
            {
                results.AddResult(
                    new ValidationResult(Resources.ERROR_B01_02_0001,
                        this, "Password", null, EventSpecificValidator.DefaultInstance));
                results.AddResult(
                    new ValidationResult(Resources.ERROR_B01_02_0001,
                        this, "ConfirmPassword", null, EventSpecificValidator.DefaultInstance));
            }
        }

    }
}
