﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.Validation.Validators;
using System.Text.RegularExpressions;

namespace Terasoluna.TourSample.Client.B01.ViewData
{
    /// <summary>
    /// ユーザ登録画面(2/3)の画面データクラス（ルート）
    /// </summary>
    [DefaultRuleset("RS01")]
    public partial class SC_B01_02_02ViewData : ValidatableRootViewData
    {
        [DisplayName("メールアドレス")]
        [RequiredValidator(Tag = "メールアドレス", Ruleset = "RS01")]
        [RegexValidatorEx(@"\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*",
            RegexOptions.IgnoreCase, Tag = "メールアドレス", Ruleset = "RS01")]
        public virtual string Email { get; set; }

        [DisplayName("住所")]
        public virtual string Address { get; set; }

        [DisplayName("会社名")]
        public virtual string CompanyName { get; set; }

        /// <summary>
        /// ログインユーザ
        ///
        /// </summary>
        public virtual SC_B01_02LoginUser LoginUser { get; set; }
    }
}
