﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.Windows.Forms.FormForward;
using Terasoluna.TourSample.Client.Common.View;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.TourSample.Client.B01.ViewData;
using Terasoluna.Windows.Forms.Events;
using Terasoluna.DataCopy;

namespace Terasoluna.TourSample.Client.B01.View
{
    /// <summary>
    /// ユーザ登録画面(2/3)
    /// </summary>
    [ScreenId("SC_B01_02_02")]
    public partial class SC_B01_02_02View : TourSampleViewBase
    {
        /// <summary>
        /// 画面データ
        /// </summary>
        public SC_B01_02_02ViewData ViewData { get; set; }

        public SC_B01_02_02View()
        {
            InitializeComponent();
            ViewData = ValidatableViewDataManager.CreateViewData<SC_B01_02_02ViewData>();
        }

        private void SC_B01_02_02View_Load(object sender, EventArgs e)
        {
            sC_B01_02_01ViewDataBindingSource.DataSource = ViewData;
        }

        /// <summary>
        /// 戻るボタン押下
        /// </summary>
        private void backButton_Click(object sender, EventArgs e)
        {
            //非表示にして遷移元画面へ戻る
            Hide();
        }

        /// <summary>
        /// 次へボタン押下
        /// </summary>
        private void forwardToSC_B01_02_03Button_Click(object sender, EventArgs e)
        {
            EventProcessResult result = b01_02_02_C01EventProcessWorker.RunWorker();
            if (result.IsSuccess)
            {
                formForwarderToSC_B01_02_03.Forward();
            }
        }

        /// <summary>
        /// 次画面遷移時
        /// </summary>
        private void formForwarderToSC_B01_02_03_ForwardFormLoading(object sender, ForwardFormLoadingEventArgs e)
        {
            //ユーザ情報登録確認画面へ引き継ぐため、
            //画面遷移前にスコープ共通領域からユーザ情報入力画面のデータを取得し、画面データへコピー
            object sC_B01_02_01ViewData = FormForwardManager.GetScope(this)["SC_B01_02_01ViewData"];
            if (sC_B01_02_01ViewData != null)
            {
                //次画面の画面データへディープコピー
                DataCopyManager.Copy(sC_B01_02_01ViewData, e.ViewData);
            }            
            //本画面データを次画面の画面データへディープコピーする
            //通常、画面間の引き渡しは、Visual Studioのプロパティエディタで
            //FormForwarder.ForwardMapping.DestinationTargetPropertyPathsプロパティに
            //コピー対象の項目を明示するが、
            //ShowAndHideに関しては、画面データのほぼ全ての項目を引き継ぐ必要があるので
            //DataCopyManager.Copyメソッドを呼び出すことで無条件にコピーする
            DataCopyManager.Copy(ViewData, e.ViewData);
        }

        private void helpButton_Click(object sender, EventArgs e)
        {
            Help.ShowHelp(this, "sample.chm");
        }
    }
}
