﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.DataCopy;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.Windows.Forms.FormForward;
using Terasoluna.Windows.Forms.MessageNotification;
using Terasoluna.Windows.ViewModel;
using Terasoluna.TourSample.Client.Common.View;
using Terasoluna.TourSample.Client.B01.ViewData;

namespace Terasoluna.TourSample.Client.B01.View
{
    /// <summary>
    /// ユーザ管理メニュー画面
    /// </summary>
    [ScreenId("SC_B01_02_00")]
    public partial class SC_B01_02_00View : TourSampleViewBase
    {
        /// <summary>
        /// 画面データ
        /// </summary>
        public SC_B01_02_00ViewData ViewData { get; set; }

        public SC_B01_02_00View()
        {
            InitializeComponent();
            // ViewDataクラスを作成後、コメント化を解除して下さい。
            ViewData = ValidatableViewDataManager.CreateViewData<SC_B01_02_00ViewData>();
        }

        private void SC_B01_02_00View_Load(object sender, EventArgs e)
        {
            // バインディングソース名が確定したら、修正後コメント化を解除して下さい。
            sC_B01_02_00ViewDataBindingSource.DataSource = ViewData;
        }

        /// <summary>
        /// ユーザ登録ボタン押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void registerButton_Click(object sender, EventArgs e)
        {
            formForwarderToSC_B01_02_01.Forward();
        }

        private void helpButton_Click(object sender, EventArgs e)
        {
            Help.ShowHelp(this, "sample.chm");
        }
    }
}
