﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Terasoluna.Windows.Forms.FormForward;
using Terasoluna.Windows.ViewModel.Validation;
using System.IO;
using Terasoluna.Windows.Forms.MessageNotification;
using Terasoluna.TourSample.Client.Common.View;
using Terasoluna.TourSample.Client.A01.ViewData;
using Terasoluna.TourSample.Client.Properties;


namespace Terasoluna.TourSample.Client.A01.View
{
    /// <summary>
    /// ツアー情報アップロード画面
    /// </summary>
    [ScreenId("SC_A01_03_01")]
    public partial class SC_A01_03_01View : SC_Z99_01View
    {
        /// <summary>
        /// 画面データ
        /// </summary>
        public SC_A01_03_01ViewData ViewData { get; set; }

        public SC_A01_03_01View()
        {
            InitializeComponent();
            ViewData = ValidatableViewDataManager.CreateViewData<SC_A01_03_01ViewData>();        
        }

        private void SC_A01_03_01View_Load(object sender, EventArgs e)
        {
            sC_A01_03_01ViewDataBindingSource.DataSource = ViewData;
        }

        /// <summary>
        /// 参照ボタン押下
        /// </summary>
        private void referButton_Click(object sender, EventArgs e)
        {
            DialogResult result = openFileDialog1.ShowDialog(this);
            if (result == DialogResult.OK)
            {
                ViewData.UploadFilePath = openFileDialog1.FileName;                
            }

        }

        /// <summary>
        /// 登録（Stream)ボタン押下
        /// </summary>
        private void uploadStreamButton_Click(object sender, EventArgs e)
        {
            a01_03_01_C01EventProcessWorker.RunWorkerAsync();
        }

        /// <summary>
        /// 登録（byte[])ボタン押下
        /// </summary>
        private void uploadByteButton_Click(object sender, EventArgs e)
        {
            a01_03_01_C02EventProcessWorker.RunWorkerAsync();
 
        }

        /// <summary>
        /// 登録（Stream)ボタン押下時のイベント処理完了時
        /// </summary>
        private void a01_03_01_C01EventProcessWorker_Completed(object sender, Terasoluna.Windows.Forms.Events.EventProcCompletedEventArgs e)
        {
            if (e.Result.IsSuccess)
            {
                MessageNotifier.ShowInformationMessage(this, Resources.INFO_A01_03_0001);
            }
        }

        /// <summary>
        /// 登録（byte[])ボタン押下時のイベント処理完了時
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void a01_03_01_C02EventProcessWorker_Completed(object sender, Terasoluna.Windows.Forms.Events.EventProcCompletedEventArgs e)
        {
            if (e.Result.IsSuccess)
            {            
                MessageNotifier.ShowInformationMessage(this, Resources.INFO_A01_03_0001);            
            }
        }                            
    }
}
