﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.Windows.Forms.FormForward;
using Terasoluna.Windows.Forms.MessageNotification;
using System.IO;
using Terasoluna.TourSample.Client.Common.View;
using Terasoluna.TourSample.Client.A01.ViewData;

using Terasoluna.TourSample.Client.A01.Dto;
using Terasoluna.TourSample.Client.A01_02MtomServiceReference;
using Terasoluna.TourSample.Client.Properties;

namespace Terasoluna.TourSample.Client.A01.View
{
    /// <summary>
    /// ツアー情報検索画面
    /// </summary>
    [ScreenId("SC_A01_02_01")]
    public partial class SC_A01_02_01View : SC_Z99_01View
    {
        /// <summary>
        /// 画面データ
        /// </summary>
        public SC_A01_02_01ViewData ViewData { get; set; }

        public SC_A01_02_01View()
        {
            InitializeComponent();
            ViewData = ValidatableViewDataManager.CreateViewData<SC_A01_02_01ViewData>();
        }

        private void SC_A01_02_01View_Load(object sender, EventArgs e)
        {
            sC_A01_02_01ViewDataBindingSource.DataSource = ViewData;
        }

        /// <summary>
        /// 検索ボタン押下時
        /// </summary>
        private void searchTourButton_Click(object sender, EventArgs e)
        {
            a01_02_01_C01EventProcessWorker.RunWorkerAsync();
        }

        /// <summary>
        /// 検索ボタン押下時のイベント処理完了時
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void a01_02_01_C01EventProcessWorker_Completed(object sender, Terasoluna.Windows.Forms.Events.EventProcCompletedEventArgs e)
        {
            if (!e.Result.IsSuccess)
            {
                return;
            }
            if (ViewData.TourList == null || ViewData.TourList.Count == 0)
            {
                ///検索結果が１件もなかった時
                MessageNotifier.ShowInformationMessage(this, Resources.INFO_A01_02_0001);
            }
        }

        /// <summary>
        /// 一括ダウンロード（Stream）ボタン押下時
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void downloadStreamToursButton_Click(object sender, EventArgs e)
        {
            a01_02_01_C02EventProcessWorker.RunWorkerAsync();
        }

        /// <summary>
        /// 一括ダウンロード（Stream）ボタン押下時のイベント完了時
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void a01_02_01_C02EventProcessWorker_Completed(object sender, Terasoluna.Windows.Forms.Events.EventProcCompletedEventArgs e)
        {
            if (!e.Result.IsSuccess)                              
            {
                return;
            }
            ///ダウンロードに成功した場合
            A01_02_01_C02OutputDto outputDto = e.Result.BizLogicResult as A01_02_01_C02OutputDto;
            string tempFileName = outputDto.TempFileName;
            if (string.IsNullOrEmpty(tempFileName))
            {
                return;
            }
            DialogResult result = saveFileDialog1.ShowDialog();
            if (result == DialogResult.OK)
            {
                string outputFileName = saveFileDialog1.FileName;
                File.Copy(tempFileName, outputFileName, true);
                MessageNotifier.ShowInformationMessage(this, Resources.INFO_A01_02_0002);
            }
            ///一時ファイルの削除
            File.Delete(tempFileName);
        }

        /// <summary>
        /// 一括ダウンロード(byte[])ボタン押下時
        /// </summary>       
        private void downloadByteArrayToursButton_Click(object sender, EventArgs e)
        {
            a01_02_01_C03EventProcessWorker.RunWorkerAsync();
        }

        /// <summary>
        /// 一括ダウンロード(byte[])ボタン押下時のイベント完了時
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void a01_02_01_C03EventProcessWorker_Completed(object sender, Terasoluna.Windows.Forms.Events.EventProcCompletedEventArgs e)
        {
            if (!e.Result.IsSuccess)
            {
                return;
            }
            ///ダウンロードに成功した場合
            A01_02_01_S03OutputDto outputDto = e.Result.BizLogicResult as A01_02_01_S03OutputDto;

            saveFileDialog1.FileName = outputDto.FileName;                    

            DialogResult result = saveFileDialog1.ShowDialog();
            if (result == DialogResult.OK)
            {
                using (FileStream outputFile = File.Create(saveFileDialog1.FileName))
                {
                    outputFile.Write(outputDto.FileData, 0, outputDto.FileData.Length);
                }
                MessageNotifier.ShowInformationMessage(this, Resources.INFO_A01_02_0002);
            }
        }

    }
}
