﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.Windows.Forms.FormForward;
using Terasoluna.DataCopy;
using Terasoluna.Windows.Forms.MessageNotification;
using Terasoluna.TourSample.Client.Common.View;
using Terasoluna.TourSample.Client.A01.ViewData;


using Terasoluna.TourSample.Client.Common.Code;
using Terasoluna.Windows.ViewModel;
using Terasoluna.TourSample.Client.A01_01ServiceReference;

using Terasoluna.TourSample.Client.Properties;

namespace Terasoluna.TourSample.Client.A01.View
{
    /// <summary>
    /// ツアー情報登録画面
    /// </summary>
    [ScreenId("SC_A01_01_01")]
    public partial class SC_A01_01_01View : SC_Z99_01View
    {        
        ///ViewDataという名前の画面データのプロパティで定義すること
        public SC_A01_01_01ViewData ViewData { get; set; }

        public SC_A01_01_01View()
        {
            InitializeComponent();
            ///画面遷移機能で画面データの引き継ぎをするためには
            ///コンストラクタで画面データのインスタンスを生成する必要がある
            ViewData = ValidatableViewDataManager.CreateViewData<SC_A01_01_01ViewData>();
        }

        private void SC_A01_01_01View_Load(object sender, EventArgs e)
        {
            ///BindingSourceへの設定
            sC_A01_01_01ViewDataBindingSource.DataSource = ViewData;
        }
        
        /// <summary>
        /// 登録ボタン押下時
        /// </summary>
        private void registTourButton_Click(object sender, EventArgs e)
        {            
            ///イベント非同期実行
            a01_01_01_C01EventProcessWorker.RunWorkerAsync();            

        }
        /// <summary>
        /// 追加ボタン押下時
        /// </summary>
        private void addChargeButton_Click(object sender, EventArgs e)
        {    
            //担当者登録画面へ遷移
            formForwarderToSC_A01_01_02.Forward();
            
        }

        /// <summary>
        /// 担当者登録画面(SC_A01_01_02)がOKボタン押下で閉じられた時に担当者テーブルに追加する
        /// </summary>
        private void formForwarderToSC_A01_01_02_ForwardedFormClosed(object sender,  ForwardFormClosedEventArgs e)
        {            
            if (e.DialogResult == DialogResult.OK)
            {                
                ///行の追加はAddNewメソッドで追加する
                SC_A01_01_01Conductor newConductor = ViewData.ConductorList.AddNew();
                ///データコピー機能を使って遷移先画面データの値からデータコピー
                MappingInfo mapingInfo = new MappingInfo();
                ///自動コピーされないものについて個別でのマッピング設定の例
                mapingInfo.AddMapping("ConductorName", "Name");                
                DataCopyManager.Copy(e.ViewData, newConductor, mapingInfo);                                
            }
        }

        /// <summary>
        /// ビジネスロジック実行直前
        /// </summary>
        private void a01_01_01_C01EventProcessWorker_Executing(object sender, Terasoluna.Windows.Forms.Events.BizLogicExecutingEventArgs e)
        {
            ///確認ダイアログの表示
            bool result = MessageNotifier.ShowConfirmMessage(this, Resources.INFO_A01_01_0001);
            ///キャンセルの場合はイベントを中断する
            e.Cancel = !result;
        }

        /// <summary>
        /// 登録ボタン押下時のイベント処理完了時
        /// </summary>
        private void a01_01_01_C01EventProcessWorker_Completed(object sender, Terasoluna.Windows.Forms.Events.EventProcCompletedEventArgs e)
        {
            if (e.Result.IsSuccess)
            {
                ///情報ダイアログの表示
                MessageNotifier.ShowInformationMessage(this, Terasoluna.TourSample.Client.Common.Properties.Resources.INFO_COMMON_0001);
            }
        }
        
        /// <summary>
        /// 入力値検証処理実行直前
        /// </summary>
        private void a01_01_01_C01EventProcessWorker_Validating(object sender, Terasoluna.Windows.Forms.Events.ViewDataValidatingEventArgs e)
        {
            ///出発地の複数選択可能なリストボックスのエラーをクリア
            errorProviderForDeptPlaceListBox.Clear();
        }

        /// <summary>
        /// 入力値検証エラー時
        /// </summary>
        private void a01_01_01_C01EventProcessWorker_DisplayedValidationResults(object sender, Terasoluna.Windows.Forms.Events.ViewDataValidationEventArgs e)
        {
            ///例外的に出発地の複数選択可能なリストボックスのエラーをErrorProviderで個別で表示
            ValidationErrorInfo errorInfo = ViewData.Tour.GetValidationError("DeptPlaceList");
            if (errorInfo != null)
            {
                errorProviderForDeptPlaceListBox.SetError(deptPlaceListSelectedItemsBindableListBox, errorInfo.Message);
            }
        }
        
        /// <summary>
        /// クリアボタン押下時
        /// </summary>
        private void clearButton_Click(object sender, EventArgs e)
        {
            ///画面データを再生成し、BindingSourceのデータソースを再設定
            ViewData = ValidatableViewDataManager.CreateViewData<SC_A01_01_01ViewData>();
            sC_A01_01_01ViewDataBindingSource.DataSource = ViewData;
        }
       
    }
}
