﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Terasoluna.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using Terasoluna.Windows.Forms.Threading;
using Terasoluna.TourSample.Client.A01.Dto;
using Terasoluna.Threading;
using Terasoluna.Windows.Forms.Events;
using System.ComponentModel;
using Terasoluna.TourSample.Client.A01.View;
using Terasoluna.TourSample.Client.Common.VirusCheck;
using Microsoft.Practices.Unity;
using Terasoluna.ExceptionHandling;
using Terasoluna.TourSample.Client.Common.FileCheck;
using Terasoluna.BizLogic;

namespace Terasoluna.TourSample.Client.A01.BizLogic
{
    /// <summary>
    /// クライアントに閉じた処理
    /// 例外的にビジネスロジックの処理途中で画面更新しなければならならない場合の例
    /// </summary>
    public class A01_04_01_C01BizLogic
    {
        /// 全ての開発者にウィルスチェックソフトがない場合などを考慮し、
        /// ウィルスチェック処理をモックに差し替えられるようDIしている例
        [Dependency]
        public IVirusChecker VirusChecker { get; set; }

        /// name属性を指定してDIする例
        /// ファイル形式チェッククラス
        [Dependency("FormatCheck")]
        public IFileChecker FileFormatChecker { get; set; }

        /// name属性を指定してDIする例        
        /// ファイル内容チェッククラス
        [Dependency("BizCheck")]
        public IFileChecker FileBizChecker { get; set; }

        private bool Canceled
        {
            get
            {
                return InvocationScope.Current.GetContext<EventProcessContext>().CancellationPending;
            }
        }

        public void Execute(A01_04_01_C01InputDto inputDto)
        {

            SC_A01_04_01View view =
                InvocationScope.Current.GetContext<EventProcessContext>().TargetForm
                as SC_A01_04_01View;
            if (view != null)
            {
                ///イベントの登録
                VirusChecker.ProgressChanged += view.VirusCheckProgressChanged;
                FileFormatChecker.ProgressChanged += view.FormatCheckProgressChanged;
                FileBizChecker.ProgressChanged += view.BizCheckProgressChanged;
            }
            if (Canceled)
            {
                return;
            }
            ///ウィルスチェック
            VirusCheckResult virusResult = VirusChecker.CheckFile(inputDto.FilePath);
            if (Canceled)
            {
                return;
            }
            ///ファイル形式チェック
            FileCheckResult formatResult = FileFormatChecker.CheckFile(inputDto.FilePath);
            if (Canceled)
            {
                return;
            }
            ///ファイル内容チェック
            FileCheckResult bizResult = FileBizChecker.CheckFile(inputDto.FilePath);
            if (Canceled)
            {
                return;
            }
            ///エラー情報の格納処理
            List<ErrorInfo> errors = new List<ErrorInfo>();
            if (virusResult.Status != VirusCheckStatus.SUCCESS)
            {
                errors.Add(virusResult.Error);
            }
            if (!formatResult.IsSuccess)
            {
                errors.Add(formatResult.Error);
            }
            if (!bizResult.IsSuccess)
            {
                errors.Add(bizResult.Error);
            }

            ///エラーが存在する場合には業務エラー発生
            if (errors.Count > 0)
            {
                throw new BizLogicException(
                    BizLogicExceptionErrorType.BizLogicFailure,
                    "",
                    errors);
            }

        }
    }
}
