﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Terasoluna.Logging;
using Microsoft.Practices.Unity;
using System.ServiceModel;
using Terasoluna.ServiceModel;
using Terasoluna.TourSample.Client.A01.Dto;
using Terasoluna.TourSample.Client.A01_02ServiceReference;

namespace Terasoluna.TourSample.Client.A01.BizLogic
{
    /// <summary>
    /// ツアー情報を検索するビジネスロジック
    /// 
    /// サーバ通信だけでなく
    /// クライアントビジネスロジックを伴うケース
    /// </summary>
    public class A01_02_01_C01BizLogic
    {
        /// デフォルトログの取得
        private ILogger logger = LogManager.GetLogger();

        /// <summary>
        /// エンドポイント名
        /// </summary>
        private const string EndpointName = "A01_02ServicePort";

        /// <summary>
        /// UnityContainer
        /// </summary>
        [Dependency]
        public IUnityContainer Container { get; set; }

        /// <summary>
        /// ツアー情報を検索する
        /// </summary>
        public A01_02_01_S01OutputDto Execute(A01_02_01_S01InputDto inputDto)
        {
            //クライアントで実施するビジネスロジック処理
            BeforeCommunicate(inputDto);
            A01_02_01_S01OutputDto outputDto = null;

            //サーバ処理要求
            A01_02ServiceClient client = null;
            try
            {
                ///エンドポイントアドレスの取得
                ///WCF接続先変更機能により、接続先サーバアドレスを一律置換してくれる。
                EndpointAddress address = CommunicationManager.GetReplacedEndpointAddress(Container, EndpointName);
                client = new A01_02ServiceClient(EndpointName, address);
                outputDto = client.ExecuteA01_02_01_S01(inputDto);
                client.Close();
            }
            catch (System.Exception)
            {
                if (client != null)
                {
                    client.Abort();
                }
                throw;
            }                    

            //クライアントで実施するビジネスロジック処理
            AfterCommunicate(outputDto);
            return outputDto;
            
        }
        
        ///ダミーのクライアントビジネスロジック処理
        private void BeforeCommunicate(A01_02_01_S01InputDto inputDto) {           
            ///ログの出力例
            if (logger.IsDebugEnabled)
            {
                logger.Debug(inputDto.TourName);
            }
        }


        ///ダミーのクライアントビジネスロジック処理
        private void  AfterCommunicate(A01_02_01_S01OutputDto outputDto)
        {
            ///ログの出力例
            if (logger.IsDebugEnabled)
            {
                if (outputDto != null)
                {
                    logger.Debug(outputDto.TourList.Count + "件データ取得");
                }
            }

        }

    }

}
