/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.struts.actions.AbstractDownloadObject} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * _E[heێ钊ۃNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.actions.AbstractDownloadObject
 */
public class AbstractDownloadObjectTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(AbstractDownloadObjectTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public AbstractDownloadObjectTest(String name) {
        super(name);
    }

    /**
     * testAbstractDownloadObject01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:null<br>
     *        () contentType:null<br>
     *        () charset:null<br>
     *         
     * <br>
     * ҒlF(ԕω) name:null<br>
     *        (ԕω) contentType:DEFAULT_CONTENT_TYPEݒ肳Ă邱<br>
     *        (ԕω) charset:DEFAULT_CHARSETݒ肳Ă邱<br>
     *         
     * <br>
     * contentType, charsetnull̏ꍇAftHglݒ肳邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAbstractDownloadObject01() throws Exception {
        // O

        // eXg{
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);

        // 
        assertNull(object.name);
        assertEquals(AbstractDownloadObject.DEFAULT_CONTENT_TYPE,
                object.contentType);
        assertEquals(AbstractDownloadObject.DEFAULT_CHARSET, object.charset);
    }

    /**
     * testAbstractDownloadObject02()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:"  "i󔒁j<br>
     *        () contentType:"  "i󔒁j<br>
     *        () charset:"  "i󔒁j<br>
     *         
     * <br>
     * ҒlF(ԕω) name:"  "i󔒁j<br>
     *        (ԕω) contentType:"  "i󔒁j<br>
     *        (ԕω) charset:"  "i󔒁j<br>
     *         
     * <br>
     * ϐ󔒂̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAbstractDownloadObject02() throws Exception {
        // O

        // eXg{
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01("  ",
                "  ", "  ");

        // 
        assertEquals("  ", object.name);
        assertEquals("  ", object.contentType);
        assertEquals("  ", object.charset);
    }

    /**
     * testAbstractDownloadObject03()
     * <br><br>
     * 
     *(n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:""i󕶎j<br>
     *        () contentType:""i󕶎j<br>
     *        () charset:""i󕶎j<br>
     *         
     * <br>
     * ҒlF(ԕω) name:""i󕶎j<br>
     *        (ԕω) contentType:""i󕶎j<br>
     *        (ԕω) charset:""i󕶎j<br>
     *         
     * <br>
     * ϐ󕶎̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAbstractDownloadObject03() throws Exception {
        // O

        AbstractDownloadObject object = new AbstractDownloadObjectImpl01("",
                "", "");

        // 
        assertEquals("", object.name);
        assertEquals("", object.contentType);
        assertEquals("", object.charset);
    }

    /**
     * testAbstractDownloadObject04()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:"abc"<br>
     *        () contentType:"abc"<br>
     *        () charset:"abc"<br>
     *         
     * <br>
     * ҒlF(ԕω) name:"abc"<br>
     *        (ԕω) contentType:"abc"<br>
     *        (ԕω) charset:"abc"<br>
     *         
     * <br>
     * ϐ̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAbstractDownloadObject04() throws Exception {
        // O

        AbstractDownloadObject object = new AbstractDownloadObjectImpl01("abc",
                "abc", "abc");

        // 
        assertEquals("abc", object.name);
        assertEquals("abc", object.contentType);
        assertEquals("abc", object.charset);
    }

    /**
     * testSetName01()
     * <br><br>
     * 
     *(n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:null<br>
     *         
     * <br>
     * ҒlF(ԕω) name:null<br>
     *         
     * <br>
     * namenull̏ꍇAnullݒ肳邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetName01() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);

        // eXg{
        object.setName(null);

        // 
        assertNull(object.name);
    }

    /**
     * testSetName02()
     * <br><br>
     * 
     *(n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:"  "i󔒁j<br>
     *         
     * <br>
     * ҒlF(ԕω) name:"  "i󔒁j<br>
     *         
     * <br>
     * ϐ󔒂̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetName02() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);

        // eXg{
        object.setName("  ");

        // 
        assertEquals("  ", object.name);
    }

    /**
     * testSetName03()
     * <br><br>
     * 
     *(n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:""i󕶎j<br>
     *         
     * <br>
     * ҒlF(ԕω) name:""i󕶎j<br>
     *         
     * <br>
     * ϐ󕶎̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetName03() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);

        // eXg{
        object.setName("");

        // 
        assertEquals("", object.name);
    }

    /**
     * testSetName04()
     * <br><br>
     * 
     *(n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:"abc"<br>
     *         
     * <br>
     * ҒlF(ԕω) name:"abc"<br>
     *         
     * <br>
     * ϐ̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetName04() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);

        // eXg{
        object.setName("abc");

        // 
        assertEquals("abc", object.name);
    }

    /**
     * testGetName01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:null<br>
     *         
     * <br>
     * ҒlF(߂l) String:null<br>
     *         
     * <br>
     * namenull̏ꍇAnullԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetName01() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);
        object.name = null;

        // eXg{
        String str = object.getName();

        // 
        assertNull(str);
    }

    /**
     * testGetName02()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"  "i󔒁j<br>
     *         
     * <br>
     * ҒlF(߂l) String:"  "i󔒁j<br>
     *         
     * <br>
     * ϐ󔒂̏ꍇÂ܂ܕԋp邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetName02() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);
        object.name = "  ";

        // eXg{
        String str = object.getName();

        // 
        assertEquals("  ", str);
    }

    /**
     * testGetName03()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:""i󕶎j<br>
     *         
     * <br>
     * ҒlF(߂l) String:""i󕶎j<br>
     *         
     * <br>
     * ϐ󕶎̏ꍇÂ܂ܕԋp邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetName03() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);
        object.name = "";

        // eXg{
        String str = object.getName();

        // 
        assertEquals("", str);
    }

    /**
     * testGetName04()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:"abc"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"abc"<br>
     *         
     * <br>
     * ϐ̏ꍇÂ܂ܕԋp邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetName04() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);
        object.name = "abc";

        // eXg{
        String str = object.getName();

        // 
        assertEquals("abc", str);
    }

    /**
     * testSetContentType01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() contentType:null<br>
     *         
     * <br>
     * ҒlF(ԕω) contentType:DEFAULT_CONTENT_TYPEݒ肳Ă邱<br>
     *         
     * <br>
     * contentTypenull̏ꍇAftHglݒ肳邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetContentType01() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);

        // eXg{
        object.setContentType(null);

        // 
        assertEquals(AbstractDownloadObject.DEFAULT_CONTENT_TYPE,
                object.contentType);
    }

    /**
     * testSetContentType02()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() contentType:"  "i󔒁j<br>
     *         
     * <br>
     * ҒlF(ԕω) contentType:"  "i󔒁j<br>
     *         
     * <br>
     * ϐ󔒂̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetContentType02() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);

        // eXg{
        object.setContentType("  ");

        // 
        assertEquals("  ", object.contentType);
    }

    /**
     * testSetContentType03()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() contentType:""i󕶎j<br>
     *         
     * <br>
     * ҒlF(ԕω) contentType:""i󕶎j<br>
     *         
     * <br>
     * ϐ󕶎̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetContentType03() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);

        // eXg{
        object.setContentType("");

        // 
        assertEquals("", object.contentType);
    }

    /**
     * testSetContentType04()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() contentType:"abc"<br>
     *         
     * <br>
     * ҒlF(ԕω) contentType:"abc"<br>
     *         
     * <br>
     * ϐ̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetContentType04() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);

        // eXg{
        object.setContentType("abc");

        // 
        assertEquals("abc", object.contentType);
    }

    /**
     * testGetContentType01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() contentType:null<br>
     *         
     * <br>
     * ҒlF(߂l) contentType:null<br>
     *         
     * <br>
     * ϐnull̏ꍇAnullԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetContentType01() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);
        object.contentType = null;

        // eXg{
        String str = object.getContentType();

        // 
        assertNull(str);
    }

    /**
     * testGetContentType02()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() contentType:"  "i󔒁j<br>
     *         
     * <br>
     * ҒlF(߂l) String:"  "i󔒁j<br>
     *         
     * <br>
     * ϐ󔒂̏ꍇÂ܂ܕԋp邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetContentType02() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);
        object.contentType = "  ";

        // eXg{
        String str = object.getContentType();

        // 
        assertEquals("  ", str);
    }

    /**
     * testGetContentType03()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() contentType:""i󕶎j<br>
     *         
     * <br>
     * ҒlF(߂l) String:""i󕶎j<br>
     *         
     * <br>
     * ϐ󕶎̏ꍇÂ܂ܕԋp邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetContentType03() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);
        object.contentType = "";

        // eXg{
        String str = object.getContentType();

        // 
        assertEquals("", str);
    }

    /**
     * testGetContentType04()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() contentType:"abc"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"abc"<br>
     *         
     * <br>
     * ϐ̏ꍇÂ܂ܕԋp邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetContentType04() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);
        object.contentType = "abc";

        // eXg{
        String str = object.getContentType();

        // 
        assertEquals("abc", str);
    }

    /**
     * testSetCharset01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() charset:null<br>
     *         
     * <br>
     * ҒlF(ԕω) charset:DEFAULT_CHARSETݒ肳Ă邱<br>
     *         
     * <br>
     * charsetnull̏ꍇAftHglݒ肳邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetCharset01() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);

        // eXg{
        object.setCharset(null);

        // 
        assertEquals(AbstractDownloadObject.DEFAULT_CHARSET, object.charset);
    }

    /**
     * testSetCharset02()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() charset:"  "i󔒁j<br>
     *         
     * <br>
     * ҒlF(ԕω) charset:"  "i󔒁j<br>
     *         
     * <br>
     * ϐ󔒂̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetCharset02() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);

        // eXg{
        object.setCharset("  ");

        // 
        assertEquals("  ", object.charset);
    }

    /**
     * testSetCharset03()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() charset:""i󕶎j<br>
     *         
     * <br>
     * ҒlF(ԕω) charset:""i󕶎j<br>
     *         
     * <br>
     * ϐ󕶎̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetCharset03() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);

        // eXg{
        object.setCharset("");

        // 
        assertEquals("", object.charset);
    }

    /**
     * testSetCharset04()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() charset:"abc"<br>
     *         
     * <br>
     * ҒlF(ԕω) charset:"abc"<br>
     *         
     * <br>
     * ϐ̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetCharset04() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);

        // eXg{
        object.setCharset("abc");

        // 
        assertEquals("abc", object.charset);
    }

    /**
     * testGetCharset01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() charset:null<br>
     *         
     * <br>
     * ҒlF(߂l) String:null<br>
     *         
     * <br>
     * ϐnull̏ꍇAnullԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetCharset01() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);
        object.charset = null;

        // eXg{
        String str = object.getCharset();

        // 
        assertNull(str);
    }

    /**
     * testGetCharset02()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() charset:"  "i󔒁j<br>
     *         
     * <br>
     * ҒlF(߂l) String:"  "i󔒁j<br>
     *         
     * <br>
     * ϐ󔒂̏ꍇÂ܂ܕԋp邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetCharset02() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);
        object.charset = "  ";

        // eXg{
        String str = object.getCharset();

        // 
        assertEquals("  ", str);
    }

    /**
     * testGetCharset03()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() charset:""i󕶎j<br>
     *         
     * <br>
     * ҒlF(߂l) String:""i󕶎j<br>
     *         
     * <br>
     * ϐ󕶎̏ꍇÂ܂ܕԋp邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetCharset03() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);
        object.charset = "";

        // eXg{
        String str = object.getCharset();

        // 
        assertEquals("", str);
    }

    /**
     * testGetCharset04()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() charset:"abc"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"abc"<br>
     *         
     * <br>
     * ϐ̏ꍇÂ܂ܕԋp邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetCharset04() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);
        object.charset = "abc";

        // eXg{
        String str = object.getCharset();

        // 
        assertEquals("abc", str);
    }

    /**
     * testAddHeader01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:null<br>
     *        () value:null<br>
     *        () additionalHeaders:HashMap<br>
     *         
     * <br>
     * ҒlF(ԕω) additionalHeaders:Map{[null, List[null]]}<br>
     *         
     * <br>
     * ϐnull̏ꍇAli[邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddHeader01() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);

        // eXg{
        object.addHeader(null, null);

        // 
        assertNotNull(object.additionalHeaders);
        List<String> list = object.additionalHeaders.get(null);
        assertNotNull(list);
        assertEquals(1, list.size());
        assertNull(list.get(0));
    }

    /**
     * testAddHeader02()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:"  "i󔒁j<br>
     *        () value:"  "i󔒁j<br>
     *        () additionalHeaders:HashMap<br>
     *         
     * <br>
     * ҒlF(ԕω) additionalHeaders:Map{["  "i󔒁j, List["  "i󔒁j]]}<br>
     *         
     * <br>
     * ϐ󔒂̏ꍇAli[邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddHeader02() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);

        // eXg{
        object.addHeader("  ", "  ");

        // 
        assertNotNull(object.additionalHeaders);
        List list = object.additionalHeaders.get("  ");
        assertNotNull(list);
        assertEquals(1, list.size());
        assertEquals("  ", list.get(0));
    }

    /**
     * testAddHeader03()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:""i󕶎j<br>
     *        () value:""i󕶎j<br>
     *        () additionalHeaders:HashMap<br>
     *         
     * <br>
     * ҒlF(ԕω) additionalHeaders:Map{[""i󕶎j, List[""i󕶎j]]}<br>
     *         
     * <br>
     * ϐ󕶎̏ꍇAli[邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddHeader03() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);

        // eXg{
        object.addHeader("", "");

        // 
        assertNotNull(object.additionalHeaders);
        List list = object.additionalHeaders.get("");
        assertNotNull(list);
        assertEquals(1, list.size());
        assertEquals("", list.get(0));
    }

    /**
     * testAddHeader04()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:"abc"<br>
     *        () value:"abc"<br>
     *        () additionalHeaders:HashMap<br>
     *         
     * <br>
     * ҒlF(ԕω) additionalHeaders:Map{["abc", List["abc"]]}<br>
     *         
     * <br>
     * ϐ̏ꍇAli[邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddHeader04() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);

        // eXg{
        object.addHeader("abc", "abc");

        // 
        assertNotNull(object.additionalHeaders);
        List list = object.additionalHeaders.get("abc");
        assertNotNull(list);
        assertEquals(1, list.size());
        assertEquals("abc", list.get(0));
    }

    /**
     * testAddHeader05()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:"abc"<br>
     *        () value:"def"<br>
     *        () additionalHeaders:Map{["abc", List["abc"]]}<br>
     *         
     * <br>
     * ҒlF(ԕω) additionalHeaders:Map{["abc", List["abc", "def"]]}<br>
     *         
     * <br>
     * ɃL[݂ꍇŁAL[ϐ̏ꍇAli[邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testAddHeader05() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);

        Map<String, List<String>> map = new HashMap<String, List<String>>();
        List<String> list1 = new ArrayList<String>();
        list1.add("abc");
        map.put("abc", list1);
        object.additionalHeaders = map;

        // eXg{
        object.addHeader("abc", "def");

        // 
        assertNotNull(object.additionalHeaders);
        List list2 = object.additionalHeaders.get("abc");
        assertNotNull(list2);
        assertEquals(2, list2.size());
        assertEquals("abc", list2.get(0));
        assertEquals("def", list2.get(1));
    }

    /**
     * testGetAdditionalHeaders01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() additionalHeaders:HashMap<br>
     *         
     * <br>
     * ҒlF(ԕω) additionalHeaders:Map<br>
     *         
     * <br>
     * ϐ擾ł邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetAdditionalHeaders01() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);

        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        object.additionalHeaders = hashMap;

        // eXg{

        Map map = object.getAdditionalHeaders();

        // 
        assertSame(hashMap, map);
    }

    /**
     * testGetStream01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() getStreamInternal̖߂l:ByteArrayInputStream<br>
     *         
     * <br>
     * ҒlF(߂l) InputStream:BufferedInputStream(ByteArrayInputStream)<br>
     *         
     * <br>
     * getStreamInternal̖߂lBufferedInputStreamɃbvĕԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetStream01() throws Exception {
        // O
        AbstractDownloadObject object = new AbstractDownloadObjectImpl01(null,
                null, null);

        // eXg{
        InputStream stream = object.getStream();

        // 
        assertEquals(BufferedInputStream.class, stream.getClass());
    }

}
