/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.batch.tutorial.uc0001.jb0001;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.batch.tutorial.uc0001.JB0001Data;
import jp.terasoluna.batch.tutorial.uc0001.JB0001JobContext;
import jp.terasoluna.fw.batch.messages.MessageAccessor;
import jp.terasoluna.fw.batch.openapi.BLogic;
import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;

/**
 * rWlXWbNNXB
 */
public class DBBLogic implements BLogic<JB0001Data, JB0001JobContext> {

    /**
     * ONXB
     */
    private static final Log log = LogFactory.getLog(DBBLogic.class);
    
    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    private QueryDAO queryDAO = null;
    
    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    private UpdateDAO updateDAO = null;
   
    /**
     * bZ[W擾NXB
     * SpringɂCX^Xݒ肳B
     */
    private MessageAccessor messageAccessor = null;
    
    /**
     * rWlXWbNsB
     * @param nyukinData ̓p[^
     * @param jobContext WuReLXg
     * @return rWlXWbN
     */
    public BLogicResult execute(JB0001Data nyukinData,
            JB0001JobContext jobContext) {

        //Ɖ^pt̔r
        Date torihikibi = nyukinData.getTorihikibi();
        Date unyohiduke = jobContext.getUnyohiduke();
    
    
        if (!torihikibi.before(unyohiduke)) {
            
            // >= ^pt Ȃ΃bZ[W擾Oɏo͂B
            String[] args = {nyukinData.getKokyakuid()};
            String message = messageAccessor.getMessage("msg.SampleMsg", args);
            
            log.warn(message);
            
            /* u2.2.5 O̎vł͈ȉ̃RgsLɂB */
            /*
            //rWlXWbNʃIuWFNgԋpB
            return new BLogicResult(ReturnCode.ERROR_END);

            //Cӂ̃WuIR[hݒ肷ꍇ́Aȉ̂悤ɑ2ɃWuIR[hw肷B
            //return new BLogicResult(ReturnCode.ERROR_END, 99);
            */

        }
        
        //ce[uQ
        ZandakaData zandakaData =
            queryDAO.executeForObject("UC0001.getZandakaData",
                    nyukinData.getKokyakuid() , ZandakaData.class);
    
        //YR[hꍇ͎cvZƍXV
        if (zandakaData != null) {
            int zandaka = zandakaData.getZandaka() + nyukinData.getNyukin();
            zandakaData.setZandaka(zandaka);
            zandakaData.setSaisyutorihikibi(nyukinData.getTorihikibi());
            zandakaData.setKokyakuid(nyukinData.getKokyakuid());
            updateDAO.execute("UC0001.updateZandakaData", zandakaData);
    
        //YR[hꍇ͐VK쐬
        } else {
            zandakaData = new ZandakaData();
            zandakaData.setKokyakuid(nyukinData.getKokyakuid());
            zandakaData.setZandaka(nyukinData.getNyukin());
            zandakaData.setSaisyutorihikibi(nyukinData.getTorihikibi());
            updateDAO.execute("UC0001.insertZandakaData", zandakaData);
        }
        
        //JEgAbv
        jobContext.incrementCount();
        
        //rWlXWbNʃIuWFNgԋp
        return new BLogicResult(ReturnCode.NORMAL_CONTINUE);
    }

    /**
     * QueryDAOݒ肷B
     * @param queryDAO ݒ肷QueryDAO
     */
    public void setQueryDAO(QueryDAO queryDAO) {
        this.queryDAO = queryDAO;
    }

    /**
     * UpdateDAOݒ肷B
     * @param updateDAO ݒ肷UpdateDAO
     */
    public void setUpdateDAO(UpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }

    /**
     * bZ[W擾NXݒ肷B
     * @param msgAcc bZ[W擾NX
     */
    public void setMessageAccessor(MessageAccessor msgAcc) {
        this.messageAccessor = msgAcc;
    }

}
