/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.monitor;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import jp.terasoluna.fw.batch.core.JobStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MBeanRegister {
    private static final Log log = LogFactory.getLog(MBeanRegister.class);
    private static int manageableJobSize = 0;
    private MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private static Map<String, JobStatus> registerMBeanJobStatusMap = new ConcurrentHashMap<String, JobStatus>();
    private static int mbeanCount = 0;
    private static Queue<String> registerParentObjectName = new ConcurrentLinkedQueue<String>();
    private static Queue<String> registerChildObjectName = new ConcurrentLinkedQueue<String>();

    public void registerMBean(JobStatus jobStatus) {
        if (jobStatus.getJobId() == null) {
            return;
        }
        try {
            String name;
            if (mbeanCount >= manageableJobSize) {
                this.unregisterMBean();
            }
            if (((ConcurrentMap)registerMBeanJobStatusMap).putIfAbsent(name = this.getRegistName(jobStatus), jobStatus) == null) {
                this.server.registerMBean(jobStatus, ObjectName.getInstance(name));
                ++mbeanCount;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[" + name + "] MBean was registered"));
                }
            } else {
                log.warn((Object)("It wasn't registered becasuse MBean name [" + name + "] overlapped."));
            }
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (AttributeNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (MBeanException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ReflectionException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private String getRegistName(JobStatus jobStatus) {
        StringBuilder name = new StringBuilder();
        name.append("JOB:name=");
        name.append(jobStatus.getJobId());
        if (!"".equals(jobStatus.getJobRequestNo())) {
            name.append("_");
            name.append(jobStatus.getJobRequestNo());
        }
        if (!registerParentObjectName.contains(name.toString())) {
            registerParentObjectName.add(name.toString());
        }
        if (jobStatus.getPartitionNo() != -1) {
            name.append(",name2=");
            name.append(jobStatus.getPartitionKey().replaceAll(":", ""));
            registerChildObjectName.add(name.toString());
        }
        return name.toString();
    }

    private void unregisterMBean() throws MalformedObjectNameException, NullPointerException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        if (registerMBeanJobStatusMap.isEmpty()) {
            return;
        }
        block0: while (mbeanCount > 0) {
            JobStatus jobStatus;
            for (String childName : registerChildObjectName) {
                jobStatus = registerMBeanJobStatusMap.get(childName);
                if (jobStatus == null || !jobStatus.getJobState().isEndStatus() || !this.deleteMBean(childName)) continue;
                registerChildObjectName.remove(childName);
                break block0;
            }
            for (String parentName : registerParentObjectName) {
                jobStatus = registerMBeanJobStatusMap.get(parentName);
                if (jobStatus == null || !jobStatus.getJobState().isEndStatus() || !this.deleteMBean(parentName)) continue;
                registerParentObjectName.remove(parentName);
                break block0;
            }
            if ((registerChildObjectName.isEmpty() || !this.deleteMBean(registerChildObjectName.poll())) && (registerParentObjectName.isEmpty() || !this.deleteMBean(registerParentObjectName.poll()))) continue;
            break;
        }
    }

    private boolean deleteMBean(String registerName) throws InstanceNotFoundException, MBeanRegistrationException, MalformedObjectNameException, NullPointerException {
        if (registerName == null) {
            return false;
        }
        ObjectName objectName = new ObjectName(registerName);
        if (this.server.isRegistered(objectName)) {
            this.server.unregisterMBean(objectName);
            --mbeanCount;
            registerMBeanJobStatusMap.remove(registerName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + registerName + "] MBean was unregister"));
            }
            return true;
        }
        return false;
    }

    public void setManageableJobSize(int manageableJobSize) {
        MBeanRegister.manageableJobSize = manageableJobSize;
    }
}

